/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceSegmentType;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequenceSegment;
import net.anwiba.spatial.coordinate.IEnvelope;

public abstract class AbstractCoordinateSequenceSegment
implements ICoordinateSequenceSegment {
    private static final long serialVersionUID = 1L;
    private final boolean isMeasured;
    private final double[][] ordinates;
    private final int measuredIndex;
    private final CoordinateSequenceSegmentType coordinateSequenceSegmentType;
    private final IEnvelope envelope;
    private int hashcode = -1;

    public AbstractCoordinateSequenceSegment(double[][] ordinates, boolean isMeasured, CoordinateSequenceSegmentType coordinateSequenceSegmentType) {
        this.coordinateSequenceSegmentType = coordinateSequenceSegmentType;
        if (ordinates.length < 2 || isMeasured && ordinates.length < 3) {
            throw new IllegalArgumentException("Coordinatesequence dimension is lower than 2");
        }
        for (int i = 1; i < ordinates.length; ++i) {
            if (ordinates[0].length == ordinates[i].length) continue;
            throw new IllegalArgumentException("ordinates count are not equal");
        }
        this.measuredIndex = isMeasured ? ordinates.length - 1 : 0;
        this.ordinates = ordinates;
        this.isMeasured = isMeasured;
        double[] min = new double[ordinates.length];
        double[] max = new double[ordinates.length];
        for (int i = 0; i < ordinates.length; ++i) {
            min[i] = ArrayUtilities.getMin((double[])ordinates[i]);
            max[i] = ArrayUtilities.getMax((double[])ordinates[i]);
        }
        this.envelope = new Envelope(min, max, isMeasured);
    }

    @Override
    public double[] getXValues() {
        return this.getOrdinates(0, "Coordinatesequence has no x values");
    }

    @Override
    public double[] getYValues() {
        return this.getOrdinates(1, "Coordinatesequence has no y values");
    }

    @Override
    public double[] getZValues() {
        return this.getOrdinates(2, "Coordinatesequence has no z values");
    }

    @Override
    public double[] getMeasuredValues() {
        if (!this.isMeasured) {
            throw new IllegalArgumentException("Coordinatesequence has no measured values");
        }
        return this.ordinates[this.measuredIndex];
    }

    private double[] getOrdinates(int index, String message) {
        int p;
        int n = p = this.isMeasured ? this.ordinates.length - 2 : this.ordinates.length - 1;
        if (p >= index) {
            return this.ordinates[index];
        }
        throw new IllegalArgumentException(message);
    }

    @Override
    public double getXValue(int index) {
        return this.getOrdinate(index, 0, "Coordinatesequence has no x values");
    }

    @Override
    public double getYValue(int index) {
        return this.getOrdinate(index, 1, "Coordinatesequence has no y values");
    }

    @Override
    public double getZValue(int index) {
        return this.getOrdinate(index, 2, "Coordinatesequence has no z values");
    }

    private double getOrdinate(int index, int dimension, String message) {
        int p;
        int n = p = this.isMeasured ? this.ordinates.length - 2 : this.ordinates.length - 1;
        if (p >= dimension) {
            return this.ordinates[dimension][index];
        }
        throw new IllegalArgumentException(message);
    }

    @Override
    public int getDimension() {
        return this.ordinates.length - (this.isMeasured ? 1 : 0);
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public double getMeasuredValue(int index) {
        if (!this.isMeasured) {
            throw new IllegalArgumentException("Coordinatesequence has no measured values");
        }
        return this.ordinates[this.measuredIndex][index];
    }

    @Override
    public ICoordinate getCoordinateN(int index) {
        double[] values = new double[this.ordinates.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.ordinates[i][index];
        }
        return new Coordinate(values, this.isMeasured);
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.ordinates[0].length;
    }

    @Override
    public double[][] getValues() {
        return this.ordinates;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean cordinateFlag = false;
        boolean ordinateFlag = false;
        for (ICoordinate coordinate : this.getCoordinates()) {
            if (cordinateFlag) {
                buffer.append("; ");
            }
            double[] values = coordinate.getValues();
            ordinateFlag = false;
            for (double value : values) {
                if (ordinateFlag) {
                    buffer.append(", ");
                }
                buffer.append(value);
                ordinateFlag = true;
            }
            cordinateFlag = true;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public Iterable<ICoordinate> getCoordinates() {
        return new Iterable<ICoordinate>(){

            @Override
            public Iterator<ICoordinate> iterator() {
                return new Iterator<ICoordinate>(){
                    int index = 0;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ICoordinate next() {
                        return AbstractCoordinateSequenceSegment.this.getCoordinateN(this.index++);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < AbstractCoordinateSequenceSegment.this.getNumberOfCoordinates();
                    }
                };
            }
        };
    }

    @Override
    public CoordinateSequenceSegmentType getType() {
        return this.coordinateSequenceSegmentType;
    }

    @Override
    public IEnvelope getEnvelope() {
        return this.envelope;
    }

    @Override
    public boolean isEmpty() {
        return this.ordinates.length == 0;
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.deepHashCode((Object[])this.ordinates);
            this.hashcode = result = 31 * result + Objects.hash(new Object[]{this.coordinateSequenceSegmentType, this.envelope, this.isMeasured, this.measuredIndex});
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCoordinateSequenceSegment other = (AbstractCoordinateSequenceSegment)obj;
        return this.coordinateSequenceSegmentType == other.coordinateSequenceSegmentType && Objects.equals(this.envelope, other.envelope) && this.isMeasured == other.isMeasured && this.measuredIndex == other.measuredIndex && Arrays.deepEquals((Object[])this.ordinates, (Object[])other.ordinates);
    }
}

