/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.Arrays;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;

public class Coordinate
implements ICoordinate {
    private static final long serialVersionUID = 1L;
    private final boolean isMeasured;
    private final double[] values;
    private int measuredIndex;

    public static ICoordinate of(double x, double y) {
        return new Coordinate(x, y);
    }

    public Coordinate(double x, double y) {
        this(new double[]{x, y}, false);
    }

    public Coordinate(double x, double y, double n, boolean isMeasured) {
        this(new double[]{x, y, n}, isMeasured);
    }

    public Coordinate(double x, double y, double z, double m) {
        this(new double[]{x, y, z, m}, true);
    }

    public Coordinate(double[] values, boolean isMeasured) {
        this.values = ArrayUtilities.copy((double[])values);
        if (this.values.length < 2 || isMeasured && this.values.length < 3) {
            throw new IllegalArgumentException("Coordinate dimension is lower than 2");
        }
        this.measuredIndex = isMeasured ? this.values.length - 1 : -1;
        this.isMeasured = isMeasured;
    }

    @Override
    public int getDimension() {
        return this.isMeasured ? this.values.length - 1 : this.values.length;
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public double getValue(int index) {
        return this.getOrdinate(index, "Coordinate has no value at index " + index);
    }

    @Override
    public double getXValue() {
        return this.getOrdinate(0, "Coordinate has no x value");
    }

    @Override
    public double getYValue() {
        return this.getOrdinate(1, "Coordinate has no y value");
    }

    @Override
    public double getZValue() {
        return this.getOrdinate(2, "Coordinate has no z value");
    }

    private double getOrdinate(int index, String message) {
        try {
            int p;
            int n = p = this.isMeasured ? this.values.length - 2 : this.values.length - 1;
            if (p >= index) {
                return this.values[index];
            }
            throw new RuntimeException(message);
        }
        catch (Exception exception) {
            throw new RuntimeException(message, exception);
        }
    }

    @Override
    public double getMeasuredValue() {
        if (!this.isMeasured) {
            throw new RuntimeException("Coordinate has no measured value");
        }
        return this.values[this.measuredIndex];
    }

    @Override
    public double[] getValues() {
        return ArrayUtilities.copy((double[])this.values);
    }

    @Override
    public ICoordinate add(ICoordinate other) {
        return this.calculate(other, (v, o) -> v + o);
    }

    @Override
    public ICoordinate subtract(ICoordinate other) {
        return this.calculate(other, (v, o) -> v - o);
    }

    private ICoordinate calculate(ICoordinate other, IDoubleOperator operator) {
        double[] result = new double[2 + (this.getDimension() > 2 && other.getDimension() > 2 ? 1 : 0) + (this.isMeasured() && other.isMeasured() ? 1 : 0)];
        for (int i = 0; i < 2; ++i) {
            result[i] = operator.operat(this.getValue(i), other.getValue(i));
        }
        if (this.getDimension() > 2 && other.getDimension() > 2) {
            result[i] = operator.operat(this.getZValue(), other.getZValue());
        }
        if (this.isMeasured() && other.isMeasured()) {
            result[i] = operator.operat(this.getMeasuredValue(), other.getMeasuredValue());
        }
        return new Coordinate(result, this.isMeasured() && other.isMeasured());
    }

    @Override
    public boolean touch(ICoordinate other) {
        for (int i = 0; i < Math.min(other.getDimension(), this.getDimension()); ++i) {
            if (other.getValue(i) == this.values[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean touch(double x, double y) {
        return x == this.values[0] && y == this.values[1];
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ICoordinate)) {
            return false;
        }
        if (object instanceof Coordinate) {
            Coordinate other = (Coordinate)object;
            return this.isMeasured == other.isMeasured && ObjectUtilities.equals((double[])this.values, (double[])other.values);
        }
        ICoordinate other = (ICoordinate)object;
        return this.isMeasured == other.isMeasured() && ObjectUtilities.equals((double[])this.values, (double[])other.getValues());
    }

    public int hashCode() {
        long bits = 0L;
        for (double value : this.values) {
            bits ^= Double.doubleToLongBits(value) * 31L;
        }
        return (int)(bits ^ bits >> 32);
    }

    @Override
    public int compareTo(ICoordinate coordinate) {
        double[] otherValues = coordinate.getValues();
        for (int i = 0; i < Math.min(otherValues.length, this.values.length); ++i) {
            if (this.values[i] < otherValues[i]) {
                return -1;
            }
            if (!(this.values[i] > otherValues[i])) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Coordinate[" + Arrays.toString(this.getValues()) + "," + this.isMeasured() + "]";
    }

    @Override
    public ICoordinate withMeasured(double value) {
        if (this.getDimension() == 2) {
            return new Coordinate(new double[]{this.getXValue(), this.getYValue(), value}, true);
        }
        return new Coordinate(new double[]{this.getXValue(), this.getYValue(), this.getZValue(), value}, true);
    }

    @Override
    public ICoordinate withAltitude(double value) {
        if (this.isMeasured()) {
            return new Coordinate(new double[]{this.getXValue(), this.getYValue(), value, this.getMeasuredValue()}, true);
        }
        return new Coordinate(new double[]{this.getXValue(), this.getYValue(), value}, false);
    }

    static interface IDoubleOperator {
        public double operat(double var1, double var3);
    }
}

