/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.List;
import net.anwiba.spatial.coordinate.CoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.LineCoordinateSequenceSegment;

public class CoordinateSequenceFactory
implements ICoordinateSequenceFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public ICoordinateSequence createEmptyCoordinateSequence(int dimension, boolean isMeasured) {
        double[][] coordinates = this.create(dimension, 0, isMeasured);
        return this.create(coordinates, isMeasured);
    }

    @Override
    public double[][] create(int dimension, int length, boolean isMeasured) {
        int i;
        int arrayDimension = isMeasured ? dimension + 1 : dimension;
        double[][] coordinates = new double[arrayDimension][];
        for (i = 0; i < coordinates.length; ++i) {
            coordinates[i] = new double[length];
        }
        if (isMeasured) {
            for (i = 0; i < coordinates[arrayDimension - 1].length; ++i) {
                coordinates[arrayDimension - 1][i] = Double.NaN;
            }
        }
        return coordinates;
    }

    @Override
    public ICoordinateSequence create(double[] values, int dimension, boolean isMeasured) {
        int numberOfOrdinates = dimension + (isMeasured ? 1 : 0);
        int numberOfCoordinates = values.length / numberOfOrdinates;
        double[][] coordinates = new double[numberOfOrdinates][numberOfCoordinates];
        for (int j = 0; j < numberOfOrdinates; ++j) {
            for (int i = 0; i < numberOfCoordinates; ++i) {
                coordinates[j][i] = values[numberOfOrdinates * i + j];
            }
        }
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys) {
        double[][] coordinates = new double[][]{{xs}, {ys}};
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys, double zs) {
        double[][] coordinates = new double[][]{{xs}, {ys}, {zs}};
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys, double ns, boolean isMeasured) {
        double[][] coordinates = new double[][]{{xs}, {ys}, {ns}};
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(double xs, double ys, double zs, double ms) {
        double[][] coordinates = new double[][]{{xs}, {ys}, {zs}, {ms}};
        return this.create(coordinates, true);
    }

    @Override
    public ICoordinateSequence create(double[] xs, double[] ys) {
        double[][] coordinates = new double[][]{xs, ys};
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double[] xs, double[] ys, double[] ns, boolean isMeasured) {
        double[][] coordinates = new double[][]{xs, ys, ns};
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(double[] xs, double[] ys, double[] zs, double[] ms) {
        double[][] coordinates = new double[][]{xs, ys, zs, ms};
        return this.create(coordinates, true);
    }

    @Override
    public ICoordinateSequence create(double[][] coordinates) {
        return this.create(coordinates, false);
    }

    @Override
    public ICoordinateSequence create(double[][] coordinates, boolean isMeasured) {
        return new CoordinateSequence(new LineCoordinateSequenceSegment(coordinates, isMeasured));
    }

    @Override
    public ICoordinateSequence create(ICoordinate ... coordinates) {
        int dimension = CoordinateSequenceFactory.getDimension(coordinates);
        boolean isMeasured = CoordinateSequenceFactory.isMeasured(coordinates);
        boolean is3D = dimension == 3;
        double[][] array = new double[dimension + (isMeasured ? 1 : 0)][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new double[coordinates.length];
            for (int j = 0; j < coordinates.length; ++j) {
                ICoordinate coordinate = coordinates[j];
                if (coordinate == null) continue;
                array[i][j] = i == 0 ? coordinate.getValue(i) : (i == 1 ? coordinate.getValue(i) : (i == 2 && is3D ? coordinate.getZValue() : (i == 2 && !is3D && isMeasured ? coordinate.getMeasuredValue() : (i == 3 && is3D && isMeasured ? coordinate.getMeasuredValue() : Double.NaN))));
            }
        }
        return this.create(array, isMeasured);
    }

    private static int getDimension(ICoordinate[] coordinates) {
        int dimension = Integer.MAX_VALUE;
        for (ICoordinate coordinate : coordinates) {
            if (coordinate == null) continue;
            dimension = Math.min(dimension, coordinate.getDimension());
        }
        return dimension == Integer.MAX_VALUE ? 2 : dimension;
    }

    private static boolean isMeasured(ICoordinate[] coordinates) {
        for (ICoordinate coordinate : coordinates) {
            if (coordinate.isMeasured()) continue;
            return false;
        }
        return coordinates.length != 0;
    }

    @Override
    public ICoordinateSequence create(double[] ordinates, int numberOfPoints, int dimensions, boolean isMeasured) {
        double[][] coordinates = new double[dimensions][];
        for (int i = 0; i < dimensions; ++i) {
            coordinates[i] = new double[numberOfPoints];
        }
        int counter = 0;
        for (int n = 0; n < numberOfPoints; ++n) {
            for (int i = 0; i < dimensions; ++i) {
                coordinates[i][n] = ordinates[counter++];
            }
        }
        return this.create(coordinates, isMeasured);
    }

    @Override
    public ICoordinateSequence create(List<ICoordinate> coordinates) {
        return this.create(coordinates.toArray(new ICoordinate[coordinates.size()]));
    }

    @Override
    public ICoordinateSequence create(int coordinateDimension, double[] coordinates, boolean is3D, boolean isMeasured) {
        int numberOfCoordinates = coordinates.length / coordinateDimension;
        double[][] values = new double[coordinateDimension][numberOfCoordinates];
        for (int i = 0; i < numberOfCoordinates; ++i) {
            for (int j = 0; j < coordinateDimension; ++j) {
                values[j][i] = coordinates[i * coordinateDimension + j];
            }
        }
        return this.create(values, coordinateDimension == 3 && isMeasured && !is3D || coordinateDimension > 3 && isMeasured);
    }

    @Override
    public ICoordinateSequence create(int dimension, boolean isMeasured, double ... values) {
        return this.create(dimension, values, isMeasured ? dimension > 3 : dimension > 2, isMeasured);
    }
}

