/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.spatial.coordinate.CoordinateCalculationException;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.ICoordinateSequenceSegment;
import net.anwiba.spatial.coordinate.LineCoordinateSequenceSegment;
import net.anwiba.spatial.coordinate.calculator.DefaultCoordinateDistanceCalculator;
import net.anwiba.spatial.coordinate.calculator.ICoordinateDistanceCalculator;
import net.anwiba.spatial.coordinate.calculator.SmallPointCalculator;

public class CoordinateSequenceUtilities {
    private static final DefaultCoordinateDistanceCalculator DISTANCE_CALCULATOR = new DefaultCoordinateDistanceCalculator();
    private static ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    public static ICoordinateSequence concat(ICoordinateSequence sequence0, ICoordinateSequence sequence1) {
        double[][] values1;
        if (sequence0 == null) {
            return sequence1;
        }
        if (sequence1 == null) {
            return sequence0;
        }
        double[][] values0 = sequence0.getValues();
        if (values0.length != (values1 = sequence1.getValues()).length) {
            throw new IllegalArgumentException("coordinate sequences with diffrent dimensions");
        }
        if (sequence0.isMeasured() != sequence1.isMeasured()) {
            throw new IllegalArgumentException("only one coordinate sequence is measued");
        }
        if (values0[0].length == 0) {
            return sequence1;
        }
        if (values1[0].length == 0) {
            return sequence0;
        }
        double[][] result = new double[values0.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ArrayUtilities.concat((double[])values0[i], (double[])values1[i]);
        }
        return coordinateSequenceFactory.create(result, sequence0.isMeasured());
    }

    public static ICoordinateSequence concat(ICoordinateSequence[] coordinateSequences) {
        int sequeneceCount = coordinateSequences.length;
        if (sequeneceCount == 0) {
            throw new IllegalArgumentException("empty coordinate sequence array");
        }
        if (sequeneceCount == 1) {
            return coordinateSequences[0];
        }
        ICoordinateSequence coordinateSequence = coordinateSequenceFactory.createEmptyCoordinateSequence(coordinateSequences[0].getDimension(), coordinateSequences[0].isMeasured());
        for (ICoordinateSequence sequence : coordinateSequences) {
            coordinateSequence = CoordinateSequenceUtilities.concat(coordinateSequence, sequence);
        }
        return coordinateSequence;
    }

    public static ICoordinateSequence concat(ICoordinateSequence sequence, ICoordinate coordinate) {
        return CoordinateSequenceUtilities.concat(sequence, new CoordinateSequenceFactory().create(coordinate));
    }

    public static ICoordinateSequence copy(ICoordinateSequence source) {
        return CoordinateSequenceUtilities.copy(source, 0, source.getNumberOfCoordinates());
    }

    private static ICoordinateSequence copy(ICoordinateSequence source, int from, int to, int length) {
        double[][] sourceValues = source.getValues();
        double[][] targetValues = coordinateSequenceFactory.create(source.getDimension(), length, source.isMeasured());
        for (int i = 0; i < sourceValues.length; ++i) {
            System.arraycopy(sourceValues[i], from, targetValues[i], to, length);
        }
        return coordinateSequenceFactory.create(targetValues, source.isMeasured());
    }

    public static ICoordinateSequence copy(ICoordinateSequence source, int from, int length) {
        return CoordinateSequenceUtilities.copy(source, from, 0, length);
    }

    public static ICoordinateSequence reverse(ICoordinateSequence coordinateSequence) {
        double[][] values = coordinateSequence.getValues();
        double[][] reverse = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            reverse[i] = ArrayUtilities.reverse((double[])values[i]);
        }
        return new CoordinateSequenceFactory().create(reverse, coordinateSequence.isMeasured());
    }

    public static ICoordinateSequenceSegment reverse(ICoordinateSequenceSegment segment) {
        double[][] values = segment.getValues();
        double[][] reverse = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            reverse[i] = ArrayUtilities.reverse((double[])values[i]);
        }
        return new LineCoordinateSequenceSegment(reverse, segment.isMeasured());
    }

    public static ICoordinate calculateCentroid(ICoordinateSequence coordinateSequence) {
        if (coordinateSequence.getNumberOfCoordinates() == 1) {
            return coordinateSequence.getCoordinateN(0);
        }
        ICoordinate centroid = null;
        for (int i = 0; i < coordinateSequence.getNumberOfCoordinates() - (coordinateSequence.isClosed() ? 1 : 0); ++i) {
            ICoordinate coordinate = coordinateSequence.getCoordinateN(i);
            centroid = centroid == null ? coordinate : CoordinateUtilities.getAvarageCoordinate(centroid, coordinate, i + 1);
        }
        return centroid;
    }

    public static ICoordinate findNearestNeighbor(ICoordinate centroid, ICoordinateSequence coordinateSequence) {
        ICoordinate result = null;
        double distance = Double.MAX_VALUE;
        for (ICoordinate coordinate : coordinateSequence.getCoordinates()) {
            double calculatedDistance = Math.abs(CoordinateUtilities.calculateDistance(centroid, coordinate));
            if (!(calculatedDistance < distance)) continue;
            distance = calculatedDistance;
            result = coordinate;
        }
        return result;
    }

    public static ICoordinateSequence createMinimalBoundingRectangleSequence(ICoordinateSequence sequence) {
        ICoordinate minimum = null;
        ICoordinate maximum = null;
        for (ICoordinate coordinate : sequence.getCoordinates()) {
            minimum = CoordinateUtilities.getMinimum(minimum, coordinate);
            maximum = CoordinateUtilities.getMaximum(maximum, coordinate);
        }
        if (minimum == null || maximum == null) {
            return coordinateSequenceFactory.create(new ICoordinate[0]);
        }
        return coordinateSequenceFactory.create(minimum, CoordinateUtilities.createAdapted(minimum, 1, maximum.getYValue()), maximum, CoordinateUtilities.createAdapted(minimum, 0, maximum.getXValue()), minimum);
    }

    public static boolean hasEqualNeigbors(ICoordinateSequence coordinateSequence, double tolerance) {
        Iterable<ICoordinate> coordinates = coordinateSequence.getCoordinates();
        ICoordinate ancestor = null;
        for (ICoordinate coordinate : coordinates) {
            if (ancestor != null && CoordinateUtilities.interact(ancestor, coordinate, tolerance)) {
                return true;
            }
            ancestor = coordinate;
        }
        return false;
    }

    public static ICoordinateSequence clean(ICoordinateSequence source, double tolerance) {
        return CoordinateSequenceUtilities.clean(DISTANCE_CALCULATOR, source, tolerance);
    }

    public static ICoordinateSequence clean(ICoordinateDistanceCalculator calculator, ICoordinateSequence source, double tolerance) {
        ICoordinate last = null;
        ArrayList<ICoordinate> result = new ArrayList<ICoordinate>();
        for (ICoordinate coordinate : source.getCoordinates()) {
            if (last == null) {
                last = coordinate;
                continue;
            }
            if (CoordinateSequenceUtilities.touches(coordinate, last, tolerance)) continue;
            result.add(last);
            last = coordinate;
        }
        ICoordinate lastCoordinate = source.getCoordinateN(source.getNumberOfCoordinates() - 1);
        if (lastCoordinate.equals(last)) {
            result.add(last);
        } else {
            result.set(result.size() - 1, last);
        }
        return coordinateSequenceFactory.create(result);
    }

    public static boolean touches(ICoordinate coordinate, ICoordinate other, double tolerance) {
        return tolerance <= 0.0 && other.equals(coordinate) || tolerance > 0.0 && CoordinateUtilities.calculateDistance(other, coordinate) <= tolerance;
    }

    public static ICoordinateSequence parallel(ICoordinateSequence sequence, double distance) throws CoordinateCalculationException {
        Iterable<Segment> segments = CoordinateSequenceUtilities.createSegmentIterable(sequence);
        Segment firstParallel = null;
        Segment previousParallel = null;
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        for (Segment segment : segments) {
            Segment nextParallel = CoordinateSequenceUtilities.parallel(segment, distance);
            if (firstParallel == null) {
                firstParallel = nextParallel;
                previousParallel = nextParallel;
                coordinates.add(nextParallel.from);
                continue;
            }
            try {
                coordinates.add(CoordinateUtilities.calculateIntersection(previousParallel.from, previousParallel.to, nextParallel.to, nextParallel.from));
            }
            catch (CoordinateCalculationException exception) {
                coordinates.add(CoordinateUtilities.calculateSmallPoint(previousParallel.to, previousParallel.from, -distance));
                coordinates.add(CoordinateUtilities.calculateSmallPoint(nextParallel.from, nextParallel.to, -distance));
            }
            previousParallel = nextParallel;
        }
        if (previousParallel == null) {
            return new CoordinateSequenceFactory().create(coordinates);
        }
        coordinates.add(previousParallel.to);
        if (sequence.isClosed()) {
            try {
                ICoordinate intersection = CoordinateUtilities.calculateIntersection(previousParallel.from, previousParallel.to, firstParallel.to, firstParallel.from);
                coordinates.set(0, intersection);
                coordinates.set(coordinates.size() - 1, intersection);
            }
            catch (CoordinateCalculationException exception) {
                coordinates.add(CoordinateUtilities.calculateSmallPoint(previousParallel.to, previousParallel.from, -distance));
                ICoordinate point = CoordinateUtilities.calculateSmallPoint(firstParallel.from, firstParallel.to, -distance);
                coordinates.set(0, point);
                coordinates.set(coordinates.size() - 1, point);
            }
        }
        return new CoordinateSequenceFactory().create(coordinates);
    }

    private static Segment parallel(Segment segment, double distance) {
        SmallPointCalculator calculator = new SmallPointCalculator(segment.from, segment.to);
        ICoordinate from = calculator.calculate(0.0, distance);
        ICoordinate to = calculator.calculate(DISTANCE_CALCULATOR.calculate(segment.from, segment.to), distance);
        return new Segment(from, to);
    }

    private static Iterable<Segment> createSegmentIterable(final ICoordinateSequence sequence) {
        return new Iterable<Segment>(){

            @Override
            public Iterator<Segment> iterator() {
                final Iterator<ICoordinate> iterator = sequence.getCoordinates().iterator();
                return new Iterator<Segment>(){
                    ICoordinate previous = null;
                    Segment segment = null;

                    @Override
                    public boolean hasNext() {
                        if (this.segment != null) {
                            return true;
                        }
                        if (!iterator.hasNext()) {
                            return false;
                        }
                        if (this.previous == null) {
                            this.previous = (ICoordinate)iterator.next();
                            if (!iterator.hasNext()) {
                                return false;
                            }
                        }
                        ICoordinate next = (ICoordinate)iterator.next();
                        this.segment = new Segment(this.previous, next);
                        this.previous = next;
                        return true;
                    }

                    @Override
                    public Segment next() {
                        try {
                            Segment segment = this.segment;
                            return segment;
                        }
                        finally {
                            this.segment = null;
                        }
                    }
                };
            }
        };
    }

    public static List<List<ICoordinate>> getDuplicatedSupportingPoints(ICoordinateSequence coordinateSequence, double tolerance) {
        ArrayList<List<ICoordinate>> coordinates = new ArrayList<List<ICoordinate>>();
        ICoordinate previous = null;
        for (ICoordinate coordinate : coordinateSequence.getCoordinates()) {
            if (previous == null) {
                previous = coordinate;
                continue;
            }
            if (CoordinateUtilities.calculateDistance(previous, coordinate) < tolerance) {
                coordinates.add(Arrays.asList(previous, coordinate));
            }
            previous = coordinate;
        }
        return coordinates;
    }

    public static boolean isRectangle(ICoordinateSequence coordinateSequence) {
        ICoordinateSequence sequence = CoordinateSequenceUtilities.removePointsOnStaightLineAndDupplicates(coordinateSequence, 5);
        if (sequence.getNumberOfCoordinates() != 5) {
            return false;
        }
        if (sequence.getXValue(0) == sequence.getXValue(1)) {
            if (sequence.getYValue(1) != sequence.getYValue(2)) {
                return false;
            }
            if (sequence.getXValue(2) != sequence.getXValue(3)) {
                return false;
            }
            return sequence.getYValue(3) == sequence.getYValue(4);
        }
        if (sequence.getYValue(0) == sequence.getYValue(1)) {
            if (sequence.getXValue(1) != sequence.getXValue(2)) {
                return false;
            }
            if (sequence.getYValue(2) != sequence.getYValue(3)) {
                return false;
            }
            return sequence.getXValue(3) == sequence.getXValue(4);
        }
        return false;
    }

    private static ICoordinateSequence removePointsOnStaightLineAndDupplicates(ICoordinateSequence coordinateSequence, int breakSize) {
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        ICoordinate previous = null;
        ICoordinate next = null;
        double gradient = Double.NaN;
        for (ICoordinate coordinate : coordinateSequence.getCoordinates()) {
            if (previous == null) {
                previous = coordinate;
                coordinates.add(coordinate);
                continue;
            }
            if (next == null) {
                gradient = CoordinateSequenceUtilities.calculateGradient(previous, coordinate);
                next = coordinate;
                continue;
            }
            double currentGradient = CoordinateSequenceUtilities.calculateGradient(previous, coordinate);
            if (currentGradient == gradient) {
                next = coordinate;
                continue;
            }
            coordinates.add(next);
            if (coordinates.size() > breakSize) {
                return coordinateSequence;
            }
            gradient = currentGradient;
            previous = next;
            next = coordinate;
        }
        if (next != null) {
            coordinates.add(next);
        }
        return new CoordinateSequenceFactory().create(coordinates);
    }

    private static double calculateGradient(ICoordinate previous, ICoordinate next) {
        return (next.getXValue() - previous.getXValue()) / (next.getYValue() - previous.getYValue());
    }

    public static List<ICoordinate> calculateCrossPoints(ICoordinateSequence coordinateSequenceOfEnvelope, ICoordinate previous, ICoordinate coordinate) {
        return List.of();
    }

    public static class Segment {
        private final ICoordinate from;
        private final ICoordinate to;

        public Segment(ICoordinate from, ICoordinate to) {
            this.from = from;
            this.to = to;
        }

        public ICoordinate getFrom() {
            return this.from;
        }

        public ICoordinate getTo() {
            return this.to;
        }
    }
}

