/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ILineSegment;
import net.anwiba.spatial.coordinate.LineSegment;

public class LineSegmentIterable
implements Iterable<ILineSegment> {
    private final ICoordinateSequence sequence;

    public LineSegmentIterable(ICoordinateSequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public Iterator<ILineSegment> iterator() {
        return new LineSegmentIterator(this.sequence);
    }

    public static final class LineSegmentIterator
    implements Iterator<ILineSegment> {
        private final Iterator<ICoordinate> iterator;
        private ICoordinate previous;
        private ILineSegment next;

        public LineSegmentIterator(ICoordinateSequence sequence) {
            this.iterator = sequence.getCoordinates().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext() && this.next == null) {
                ICoordinate coordinate = this.iterator.next();
                if (this.previous == null) {
                    this.previous = coordinate;
                    continue;
                }
                this.next = new LineSegment(this.previous, coordinate);
                this.previous = coordinate;
            }
            return this.next != null;
        }

        @Override
        public ILineSegment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                ILineSegment iLineSegment = this.next;
                return iLineSegment;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

