/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import net.anwiba.commons.utilities.math.MathWrapper;
import net.anwiba.spatial.coordinate.calculator.ICoordinateDistanceCalculator;

public class CoordinateHaversineDistanceCalculator
implements ICoordinateDistanceCalculator {
    private final double earthRadius;

    public CoordinateHaversineDistanceCalculator(double earthRadius) {
        this.earthRadius = earthRadius;
    }

    @Override
    public double calculate(double lambda, double phi, double otherLambda, double otherPhi) {
        double latitudeDistance = MathWrapper.toRadians((double)(otherPhi - phi));
        double longitudeDistance = MathWrapper.toRadians((double)(otherLambda - lambda));
        double a = MathWrapper.sin((double)(latitudeDistance / 2.0)) * MathWrapper.sin((double)(latitudeDistance / 2.0)) + MathWrapper.cos((double)MathWrapper.toRadians((double)phi)) * MathWrapper.cos((double)MathWrapper.toRadians((double)otherPhi)) * MathWrapper.sin((double)(longitudeDistance / 2.0)) * MathWrapper.sin((double)(longitudeDistance / 2.0));
        return this.earthRadius * (2.0 * MathWrapper.atan2((double)MathWrapper.sqrt((double)a), (double)MathWrapper.sqrt((double)(1.0 - a))));
    }
}

