/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.DirectionAngle;
import net.anwiba.commons.utilities.math.DirectionOrientation;
import net.anwiba.commons.utilities.math.MathWrapper;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.calculator.ICoordinateDirectionCalculator;

public class DefaultCoordinateDirectionCalculator
implements ICoordinateDirectionCalculator {
    @Override
    public Angle calculate(ICoordinate prior, ICoordinate center, ICoordinate next) {
        DirectionAngle direction = this.calculate(center, next);
        DirectionAngle otherDirection = this.calculate(center, prior);
        return DirectionOrientation.between((DirectionAngle)direction, (DirectionAngle)otherDirection);
    }

    @Override
    public DirectionAngle calculate(ICoordinate prior, ICoordinate next) {
        double a = next.getXValue() - prior.getXValue();
        double b = next.getYValue() - prior.getYValue();
        return DirectionAngle.of((Angle)Angle.radian((double)this.calculate(a, b)), (DirectionOrientation)DirectionOrientation.MATH);
    }

    private double calculate(double a, double b) {
        if (a == 0.0) {
            if (b > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        if (b == 0.0) {
            if (a > 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        double alpha = MathWrapper.atan((double)(a / b));
        if (b < 0.0) {
            return Math.PI + alpha;
        }
        if (a < 0.0) {
            return Math.PI * 2 + alpha;
        }
        return alpha;
    }
}

