/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.DirectionAngle;
import net.anwiba.commons.utilities.math.DirectionOrientation;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.calculator.DefaultCoordinateDirectionCalculator;
import net.anwiba.spatial.coordinate.calculator.DefaultCoordinateDistanceCalculator;
import net.anwiba.spatial.coordinate.calculator.IToPolarCoordinateCalculator;

public class DefaultToPolarCoordinateCalculator
implements IToPolarCoordinateCalculator {
    private final DefaultCoordinateDirectionCalculator directionCalculator = new DefaultCoordinateDirectionCalculator();
    private final DefaultCoordinateDistanceCalculator distanceCalculator = new DefaultCoordinateDistanceCalculator();

    @Override
    public ICoordinate calculate(ICoordinate coordinate, ICoordinate other) {
        double distance = this.distanceCalculator.calculate(coordinate, other);
        DirectionAngle direction = this.directionCalculator.calculate(coordinate, other);
        return Coordinate.of(distance, direction.convertTo(DirectionOrientation.GEOGRAPHIC_NORTH).degree());
    }

    @Override
    public ICoordinate calculate(ICoordinate prior, ICoordinate coordinate, ICoordinate next) {
        double distance = this.distanceCalculator.calculate(coordinate, next);
        DirectionAngle direction = this.directionCalculator.calculate(coordinate, next);
        double directionValue = DirectionAngle.of((Angle)DirectionOrientation.between((DirectionAngle)direction, (DirectionAngle)this.directionCalculator.calculate(coordinate, prior)), (DirectionOrientation)DirectionOrientation.GEOGRAPHIC_NORTH).degree();
        return Coordinate.of(distance, directionValue);
    }
}

