/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.coordinate.calculator;

import java.util.LinkedList;
import java.util.List;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.coordinate.Orientation;
import net.anwiba.spatial.coordinate.calculator.CoordinateSequenceOrientationCalculator;

public class IntersectionCalculator {
    public static List<ICoordinateSequence> intersect(ICoordinateSequenceFactory factory, ICoordinateSequence coordinateSequence, IEnvelope envelope, int dimension) {
        if (!envelope.interact(coordinateSequence.getEnvelope())) {
            return List.of();
        }
        if (envelope.contains(coordinateSequence.getEnvelope())) {
            return List.of(coordinateSequence);
        }
        if (coordinateSequence.isClosed() && dimension > 1) {
            return IntersectionCalculator.intersectClosedCoordinateSequence(factory, coordinateSequence, CoordinateSequenceOrientationCalculator.getOrientation(coordinateSequence), envelope);
        }
        return IntersectionCalculator.extracted(factory, coordinateSequence, envelope);
    }

    private static List<ICoordinateSequence> intersectClosedCoordinateSequence(ICoordinateSequenceFactory factory, ICoordinateSequence coordinateSequence, Orientation orientation, IEnvelope envelope) {
        List<ICoordinateSequence> extracted = IntersectionCalculator.extracted(factory, coordinateSequence, envelope);
        if (extracted.size() == 1) {
            return extracted;
        }
        return extracted;
    }

    private static List<ICoordinateSequence> extracted(ICoordinateSequenceFactory factory, ICoordinateSequence coordinateSequence, IEnvelope envelope) {
        LinkedList coordinatesList = new LinkedList();
        LinkedList<ICoordinate> coordinates = new LinkedList<ICoordinate>();
        ICoordinateSequence coordinateSequenceOfEnvelope = envelope.getCoordinateSequence();
        ICoordinate previous = null;
        boolean isPreviousInteracting = false;
        for (ICoordinate coordinate : coordinateSequence.getCoordinates()) {
            if (envelope.interact(coordinate)) {
                coordinates.add(coordinate);
                previous = coordinate;
                isPreviousInteracting = true;
                continue;
            }
            if (previous == null) {
                previous = coordinate;
                isPreviousInteracting = false;
                continue;
            }
            if (!isPreviousInteracting && !coordinates.isEmpty()) {
                coordinatesList.add(coordinates);
                coordinates = new LinkedList();
            }
            List<ICoordinate> crossPoints = CoordinateSequenceUtilities.calculateCrossPoints(coordinateSequenceOfEnvelope, previous, coordinate);
            for (ICoordinate crossPoint : crossPoints) {
                coordinates.add(crossPoint);
            }
            previous = coordinate;
            isPreviousInteracting = false;
        }
        if (!coordinates.isEmpty()) {
            coordinatesList.add(coordinates);
        }
        return Streams.of(coordinatesList).convert(list -> factory.create((List<ICoordinate>)list)).asList();
    }
}

