/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.optional.If;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.string.StringUtilities;

public class PackageRequestBuilder {
    private final Builder builder;

    public static Operator and() {
        return Operator.AND;
    }

    public static Operator or() {
        return Operator.OR;
    }

    public static PackageShowRequestBuilder show(String url) {
        return new PackageRequestBuilder(url).show();
    }

    public static PackageSearchRequestBuilder search(String url) {
        return new PackageRequestBuilder(url).search();
    }

    private PackageRequestBuilder(String url) {
        this.builder = new Builder(url);
    }

    private PackageShowRequestBuilder show() {
        this.builder.setType(Type.SHOW);
        return new PackageShowRequestBuilder(this.builder);
    }

    private PackageSearchRequestBuilder search() {
        this.builder.setType(Type.SEARCH);
        return new PackageSearchRequestBuilder(this.builder);
    }

    static final class Builder {
        private Type type = null;
        private String key = null;
        private final String url;
        private int rows = 1000;
        private int start = 0;
        private final Map<String, SearchCondition> searchConditions = new HashMap<String, SearchCondition>();
        private IAuthentication authentication;
        private final List<IParameter> parameters = new ArrayList<IParameter>();
        private String query;
        private final List<String> fields = new LinkedList<String>();
        private String identifier;

        public Builder(String url) {
            this.url = url;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public void setAuthentication(IAuthentication authentication) {
            this.authentication = authentication;
        }

        public void addParameter(IParameter parameter) {
            this.parameters.add(parameter);
        }

        public void addSearchCondition(SearchCondition searchCondition) {
            if (!this.searchConditions.containsKey(searchCondition.getField())) {
                this.searchConditions.put(searchCondition.getField(), searchCondition);
                return;
            }
            this.searchConditions.get(searchCondition.getField()).getValues().addAll(searchCondition.getValues());
        }

        public void setOperator(String field, Operator value) {
            if (!this.searchConditions.containsKey(field)) {
                SearchCondition searchCondition = new SearchCondition(field, Collections.emptyList());
                this.searchConditions.put(field, searchCondition);
                return;
            }
            this.searchConditions.get(field).setOperator(value);
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public IRequest build() {
            switch (this.type) {
                case SEARCH: {
                    RequestBuilder builder = RequestBuilder.get((String)MessageFormat.format("{0}/3/action/package_search", this.url)).query("start", String.valueOf(this.start)).query("rows", String.valueOf(this.rows));
                    If.isTrue((!this.searchConditions.isEmpty() ? 1 : 0) != 0).excecute(() -> builder.query("fq", this.toString(this.searchConditions.values())));
                    Optional.of((Object)this.query).convert(q -> builder.query("q", q));
                    if (this.fields.isEmpty()) {
                        return builder.build();
                    }
                    builder.query("fl", this.toString(this.fields));
                    Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
                    Optional.of((Object)this.authentication).consume(a -> {
                        RequestBuilder requestBuilder2 = builder.authentication(a.getUsername(), a.getPassword());
                    });
                    return builder.build();
                }
                case SHOW: {
                    RequestBuilder builder = RequestBuilder.get((String)MessageFormat.format("{0}/3/action/package_show", this.url)).query(this.parameters);
                    Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
                    Optional.of((Object)this.authentication).consume(a -> {
                        RequestBuilder requestBuilder2 = builder.authentication(a.getUsername(), a.getPassword());
                    });
                    Optional.of((Object)this.identifier).consume(a -> {
                        RequestBuilder requestBuilder2 = builder.query("id", this.identifier);
                    });
                    return builder.build();
                }
            }
            throw new IllegalStateException();
        }

        private String toString(List<String> fields) {
            StringBuilder builder = new StringBuilder();
            boolean flag = false;
            builder.append("[");
            for (String field : fields) {
                if (flag) {
                    builder.append(", ");
                }
                builder.append("'");
                builder.append(field);
                builder.append("'");
                flag = true;
            }
            builder.append("]");
            return builder.toString();
        }

        private String toString(Collection<SearchCondition> conditions) {
            StringBuilder builder = new StringBuilder();
            boolean flag = false;
            for (SearchCondition searchCondition : conditions) {
                if (flag) {
                    builder.append(" AND ");
                }
                builder.append(this.toString(searchCondition));
                flag = true;
            }
            return builder.toString();
        }

        private String toString(SearchCondition searchCondition) {
            StringBuilder builder = new StringBuilder();
            boolean flag = false;
            builder.append(searchCondition.getField());
            builder.append(":(");
            List<String> values = searchCondition.getValues();
            for (String value : values) {
                if (flag) {
                    builder.append(" ");
                    builder.append((Object)searchCondition.getOperator());
                    builder.append(" ");
                }
                if (value.contains(" ") || value.contains(":")) {
                    builder.append("\"");
                    builder.append(value);
                    builder.append("\"");
                } else {
                    builder.append(value);
                }
                flag = true;
            }
            builder.append(")");
            return builder.toString();
        }

        public void addResultField(String field) {
            this.fields.add(field);
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }
    }

    public static enum Operator {
        AND,
        OR;

    }

    private static class PackageSearchConditionBuilder {
        private final String fieldName;
        private final List<String> values = new LinkedList<String>();
        private final Builder builder;

        PackageSearchConditionBuilder(Builder builder, String fieldName) {
            this.builder = builder;
            this.fieldName = fieldName;
        }

        public PackageSearchConditionBuilder value(String value) {
            this.values.add(value);
            return this;
        }

        public PackageSearchConditionBuilder operator(Operator value) {
            this.builder.setOperator(this.fieldName, value);
            return this;
        }

        public PackageSearchRequestBuilder build() {
            SearchCondition searchCondition = new SearchCondition(this.fieldName, new ArrayList());
            searchCondition.getValues().addAll(this.values);
            this.builder.addSearchCondition(searchCondition);
            return new PackageSearchRequestBuilder(this.builder);
        }
    }

    public static class PackageSearchRequestBuilder {
        private final Builder builder;

        public PackageSearchRequestBuilder(Builder builder) {
            this.builder = builder;
        }

        public PackageSearchRequestBuilder parameter(IParameter parameter) {
            this.builder.addParameter(parameter);
            return this;
        }

        public PackageSearchRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.builder.setAuthentication((IAuthentication)new Authentication(userName, password));
            return this;
        }

        public PackageSearchRequestBuilder key(String key) {
            this.builder.setKey(key);
            return this;
        }

        public PackageSearchRequestBuilder rows(int rows) {
            this.builder.setRows(rows);
            return this;
        }

        public PackageSearchRequestBuilder start(int start) {
            this.builder.setStart(start);
            return this;
        }

        public PackageSearchRequestBuilder result(String field) {
            this.builder.addResultField(field);
            return this;
        }

        public PackageSearchRequestBuilder query(String query) {
            this.builder.setQuery(query);
            return this;
        }

        private PackageSearchConditionBuilder field(String field) {
            return new PackageSearchConditionBuilder(this.builder, field);
        }

        public PackageSearchRequestBuilder field(String field, String value) {
            return this.field(field).value(value).build();
        }

        public PackageSearchRequestBuilder operator(String field, Operator operator) {
            return this.field(field).operator(operator).build();
        }

        private PackageSearchConditionBuilder group() {
            return this.field("groups");
        }

        public PackageSearchRequestBuilder group(Operator operator) {
            return this.group().operator(operator).build();
        }

        public PackageSearchRequestBuilder group(String value) {
            return this.group().value(value).build();
        }

        private PackageSearchConditionBuilder license() {
            return this.field("license_id");
        }

        public PackageSearchRequestBuilder license(String value) {
            return this.license().value(value).build();
        }

        public PackageSearchRequestBuilder license(Operator operator) {
            return this.license().operator(operator).build();
        }

        private PackageSearchConditionBuilder resourceFormat() {
            return this.field("res_format");
        }

        public PackageSearchRequestBuilder resourceFormat(String value) {
            return this.resourceFormat().value(value).build();
        }

        public PackageSearchRequestBuilder resourceFormat(Operator operator) {
            return this.resourceFormat().operator(operator).build();
        }

        private PackageSearchConditionBuilder organization() {
            return this.field("organization");
        }

        public PackageSearchRequestBuilder organization(String value) {
            return this.organization().value(value).build();
        }

        public PackageSearchRequestBuilder organization(Operator operator) {
            return this.organization().operator(operator).build();
        }

        private PackageSearchConditionBuilder tags() {
            return this.field("tags");
        }

        public PackageSearchRequestBuilder tags(String value) {
            return this.tags().value(value).build();
        }

        public PackageSearchRequestBuilder tags(Operator operator) {
            return this.tags().operator(operator).build();
        }

        public IRequest build() {
            return this.builder.build();
        }
    }

    public static class PackageShowRequestBuilder {
        private final Builder builder;

        public PackageShowRequestBuilder(Builder builder) {
            this.builder = builder;
        }

        public PackageShowRequestBuilder identifier(String identifier) {
            this.builder.setIdentifier(identifier);
            return this;
        }

        public IRequest build() {
            return this.builder.build();
        }

        public PackageShowRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.builder.setAuthentication((IAuthentication)new Authentication(userName, password));
            return this;
        }

        public PackageShowRequestBuilder parameter(IParameter parameter) {
            this.builder.addParameter(parameter);
            return this;
        }

        public PackageShowRequestBuilder parameters(IParameters parameters) {
            parameters.forEach(p -> this.builder.addParameter((IParameter)p));
            return this;
        }
    }

    private static final class SearchCondition {
        private Operator operator = Operator.OR;
        private final String field;
        private final List<String> values = new ArrayList<String>();

        private SearchCondition(String field, List<String> values) {
            this.field = field;
            this.values.addAll(values);
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public List<String> getValues() {
            return this.values;
        }

        public String getField() {
            return this.field;
        }
    }

    static enum Type {
        SHOW,
        SEARCH;

    }
}

