//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.ckan.json.schema.v1_0;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;

public class SpatialGeometryString {

    private String value = null;

    public SpatialGeometryString(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public net.anwiba.spatial.geo.json.v01_0.Geometry asGeometry() {
        try {
            return new ObjectMapper().readerFor(net.anwiba.spatial.geo.json.v01_0.Geometry.class).readValue(value);
        } catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static SpatialGeometryString valueOf(net.anwiba.spatial.geo.json.v01_0.Geometry object) {
        try {
            return new SpatialGeometryString(new ObjectMapper().writerFor(net.anwiba.spatial.geo.json.v01_0.Geometry.class).writeValueAsString(object));
        } catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

}
