/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.json.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Locale;
import net.anwiba.spatial.ckan.json.types.I18String;

public class I18StringDeserializer
extends StdDeserializer<I18String> {
    final String language = Locale.getDefault().getLanguage();
    private static final long serialVersionUID = 1L;

    protected I18StringDeserializer() {
        super(I18String.class);
    }

    public I18String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode jsonNode;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return new I18String(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        LinkedHashSet names = new LinkedHashSet();
        node.fieldNames().forEachRemaining(name -> {
            boolean bl = names.add(name);
        });
        if (names.isEmpty()) {
            return null;
        }
        if (names.contains(this.language) && (jsonNode = node.get(this.language)).isTextual()) {
            return new I18String(jsonNode.asText());
        }
        for (String name2 : names) {
            JsonNode jsonNode2 = node.get(name2);
            if (!jsonNode2.isTextual()) continue;
            return new I18String(jsonNode2.asText());
        }
        return null;
    }
}

