//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.ckan.json.schema.v1_0;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.anwiba.spatial.ckan.json.factory.ExtraValueFactory;

public class Extra {

    private String key = null;
    private Object value = null;

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public static Extra create(
        @JacksonInject("extravaluefactory")
        ExtraValueFactory extravaluefactory,
        @JsonProperty("key")
        java.lang.String key,
        @JsonProperty("value")
        java.lang.Object value) {
        return extravaluefactory.create(key, value);
    }

    @JsonProperty("key")
    public void setKey(final String key) {
        this.key = key;
    }

    @JsonProperty("key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty("value")
    public void setValue(final Object value) {
        this.value = value;
    }

    @JsonProperty("value")
    public Object getValue() {
        return this.value;
    }

}
