/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.spatial.ckan.json.schema.v1_0.Group;
import net.anwiba.spatial.ckan.json.schema.v1_0.License;
import net.anwiba.spatial.ckan.json.schema.v1_0.Organization;
import net.anwiba.spatial.ckan.json.schema.v1_0.Tag;
import net.anwiba.spatial.ckan.request.IPackageQueryCondition;
import net.anwiba.spatial.ckan.request.PackageQueryCondition;
import net.anwiba.spatial.ckan.values.Envelope;

public class PackageQueryConditionBuilder {
    private String queryString;
    private Envelope envelope;
    private LocalDateTime fromDate;
    private LocalDateTime toDate;
    private final List<Organization> organizations = new ArrayList<Organization>();
    private final List<Group> groups = new ArrayList<Group>();
    private final List<Tag> tags = new ArrayList<Tag>();
    private final List<String> formats = new ArrayList<String>();
    private final List<License> licenses = new ArrayList<License>();

    public PackageQueryConditionBuilder() {
    }

    public PackageQueryConditionBuilder(IPackageQueryCondition condition) {
        if (condition == null) {
            return;
        }
        this.queryString = condition.getQueryString();
        this.envelope = condition.getEnvelope();
        this.fromDate = condition.getFromDate();
        this.toDate = condition.getToDate();
        condition.getOrganizations().forEach(v -> {
            boolean bl = this.organizations.add((Organization)v);
        });
        condition.getGroups().forEach(v -> {
            boolean bl = this.groups.add((Group)v);
        });
        condition.getTags().forEach(v -> {
            boolean bl = this.tags.add((Tag)v);
        });
        condition.getFormats().forEach(v -> {
            boolean bl = this.formats.add((String)v);
        });
        condition.getLicenses().forEach(v -> {
            boolean bl = this.licenses.add((License)v);
        });
    }

    public IPackageQueryCondition build() {
        return new PackageQueryCondition(this.queryString, this.envelope, this.fromDate, this.toDate, this.organizations, this.groups, this.tags, this.formats, this.licenses);
    }

    public PackageQueryConditionBuilder setFormats(List<String> formats) {
        this.formats.addAll(formats);
        return this;
    }

    public PackageQueryConditionBuilder setGroups(List<Group> groups) {
        this.groups.addAll(groups);
        return this;
    }

    public PackageQueryConditionBuilder setTags(List<Tag> tags) {
        this.tags.addAll(tags);
        return this;
    }

    public PackageQueryConditionBuilder setOrganizations(List<Organization> organizations) {
        this.organizations.addAll(organizations);
        return this;
    }

    public PackageQueryConditionBuilder setLicenses(List<License> licenses) {
        this.licenses.addAll(licenses);
        return this;
    }

    public PackageQueryConditionBuilder setQuery(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public PackageQueryConditionBuilder setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public PackageQueryConditionBuilder setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
        return this;
    }

    public PackageQueryConditionBuilder setEnvelope(Envelope envelope) {
        this.envelope = envelope;
        return this;
    }
}

