/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.anwiba.commons.datasource.connection.IHttpConnectionDescription;
import net.anwiba.commons.http.IObjectRequestExecutor;
import net.anwiba.commons.http.IObjectRequestExecutorBuilderFactory;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.json.schema.v1_0.Dataset;
import net.anwiba.spatial.ckan.json.schema.v1_0.License;
import net.anwiba.spatial.ckan.json.schema.v1_0.PackageSearchResultResponse;
import net.anwiba.spatial.ckan.marshaller.CkanJsonResponseUnmarshallerFactory;
import net.anwiba.spatial.ckan.request.IFormatsNameConverter;
import net.anwiba.spatial.ckan.request.IPackageQueryCondition;
import net.anwiba.spatial.ckan.request.IPackageQueryExecutor;
import net.anwiba.spatial.ckan.request.PackageRequestBuilder;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;
import net.anwiba.spatial.ckan.values.Envelope;

public class PackageQueryExecutor
implements IPackageQueryExecutor {
    private final IObjectRequestExecutorBuilderFactory requestExecutorBuilderFactory;
    private final IFormatsNameConverter formatsNameConverter;

    public PackageQueryExecutor(IObjectRequestExecutorBuilderFactory requestExecutorBuilderFactory, IFormatsNameConverter formatsNameConverter) {
        this.requestExecutorBuilderFactory = requestExecutorBuilderFactory;
        this.formatsNameConverter = formatsNameConverter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectPair<List<Dataset>, Integer> query(ICanceler canceler, IHttpConnectionDescription description, IPackageQueryCondition condition, int start, int rows) throws InterruptedException, IOException {
        IResultProducer responseProducer = (c, statusCode, statusMessage, contentType, contentEncoding, inputStream) -> (PackageSearchResultResponse)new CkanJsonResponseUnmarshallerFactory().create(PackageSearchResultResponse.class).unmarshal(inputStream);
        PackageRequestBuilder.PackageSearchRequestBuilder requestBuilder = PackageRequestBuilder.search(description.getUrl()).authentication(description.getUserName(), description.getPassword());
        Streams.of((Iterable)description.getParameters().parameters()).foreach(p -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.parameter((IParameter)p);
        });
        requestBuilder.start(start).rows(rows);
        condition.getOrganizations().forEach(v -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.organization(v.getName().toString());
        });
        condition.getLicenses().forEach(v -> {
            IOptional iOptional = Optional.of((Object)this.getLicenseTitle((License)v)).consume(t -> {
                PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.license((String)t);
            });
        });
        condition.getTags().forEach(v -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.tags(v.getName().toString());
        });
        condition.getGroups().forEach(v -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.group(v.getName().toString());
        });
        condition.getFormats().forEach(v -> this.formatsNameConverter.convert((String)v).forEach(f -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.resourceFormat((String)f);
        }));
        requestBuilder.modified(condition.getFromDate(), condition.getToDate());
        Optional.of((Object)condition.getEnvelope()).consume(e -> requestBuilder.envelope((Envelope)e));
        requestBuilder.query(StringUtilities.isNullOrEmpty((String)condition.getQueryString()) ? null : condition.getQueryString());
        IRequest request = requestBuilder.build();
        Throwable throwable = null;
        Object var10_11 = null;
        try (IObjectRequestExecutor executor = this.requestExecutorBuilderFactory.create().setResultProducer(responseProducer).addResultProducer((statusCode, contentType) -> new HashSet<Integer>(Arrays.asList(409, 400, 500)).contains(statusCode) && contentType != null && contentType.startsWith("application/json"), responseProducer).build();){
            PackageSearchResultResponse response = (PackageSearchResultResponse)executor.execute(canceler, request);
            return response.isSuccess() != false ? new ObjectPair(Arrays.asList(response.getResult().getResults()), (Object)response.getResult().getCount()) : new ObjectPair(Collections.emptyList(), (Object)0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private String getLicenseTitle(License license) {
        return (String)Optional.of((Object)license).convert(l -> l.getId()).or(() -> CkanUtilities.toString(license)).get();
    }
}

