/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.marshaller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import java.io.IOException;
import java.util.Arrays;
import net.anwiba.commons.json.AbstractJsonObjectUnmarshaller;
import net.anwiba.commons.json.IJsonObjectMarshallingExceptionFactory;
import net.anwiba.commons.lang.map.HasMapBuilder;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.spatial.ckan.json.factory.ExtraValueFactory;
import net.anwiba.spatial.ckan.json.schema.v1_0.Response;
import net.anwiba.spatial.ckan.json.schema.v1_0.Result;
import net.anwiba.spatial.ckan.marshaller.CkanJsonMapperException;
import net.anwiba.spatial.ckan.marshaller.CkanJsonMapperExceptionFactory;

public class CkanJsonObjectUnmarshaller<T>
extends AbstractJsonObjectUnmarshaller<T, Response, CkanJsonMapperException> {
    private static ILogger logger = Logging.getLogger(CkanJsonObjectUnmarshaller.class);

    public CkanJsonObjectUnmarshaller(Class<T> clazz) {
        super(clazz, Response.class, new HasMapBuilder().put((Object)"extravaluefactory", (Object)new ExtraValueFactory()).build(), Arrays.asList(new DeserializationProblemHandler(){

            public Object handleMissingInstantiator(DeserializationContext ctxt, Class<?> instClass, ValueInstantiator valueInsta, JsonParser p, String msg) throws IOException {
                if (Response.class.isAssignableFrom(instClass) || Result.class.isAssignableFrom(instClass)) {
                    return super.handleMissingInstantiator(ctxt, instClass, valueInsta, p, msg);
                }
                logger.log(ILevel.WARNING, "Cannot construct instance of '" + instClass.getName() + "', " + msg);
                return null;
            }
        }), (IJsonObjectMarshallingExceptionFactory)new CkanJsonMapperExceptionFactory());
    }
}

