/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.json.factory;

import java.io.IOException;
import java.util.Objects;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.spatial.ckan.json.schema.v1_0.ContactString;
import net.anwiba.spatial.ckan.json.schema.v1_0.Extra;
import net.anwiba.spatial.ckan.json.schema.v1_0.ExtraContacts;
import net.anwiba.spatial.ckan.json.schema.v1_0.ExtraDates;
import net.anwiba.spatial.ckan.json.schema.v1_0.ExtraGeometry;
import net.anwiba.spatial.ckan.json.schema.v1_0.ExtraLicense;
import net.anwiba.spatial.ckan.json.schema.v1_0.ExtraSpatialReference;
import net.anwiba.spatial.ckan.json.schema.v1_0.ExtraString;
import net.anwiba.spatial.ckan.json.schema.v1_0.License;
import net.anwiba.spatial.ckan.json.schema.v1_0.SpatialGeometryString;
import net.anwiba.spatial.ckan.json.schema.v1_0.SpatialReference;
import net.anwiba.spatial.ckan.json.types.DateString;
import net.anwiba.spatial.ckan.marshaller.CkanJsonObjectUnmarshallerFactory;
import net.anwiba.spatial.ckan.marshaller.CkanJsonObjectsUnmarshallerFactory;
import net.anwiba.spatial.geo.json.marshal.GeoJsonObjectUnmarshallerFactory;

public class ExtraValueFactory {
    private static ILogger logger = Logging.getLogger(ExtraValueFactory.class);
    final CkanJsonObjectUnmarshallerFactory objectUnmarshallerFactory = new CkanJsonObjectUnmarshallerFactory();
    final CkanJsonObjectsUnmarshallerFactory objectsUnmarshallerFactory = new CkanJsonObjectsUnmarshallerFactory();
    final GeoJsonObjectUnmarshallerFactory geometryUnmarshallerFactory = new GeoJsonObjectUnmarshallerFactory();

    public Extra create(String key, Object objectValue) {
        if (objectValue instanceof String) {
            String value = (String)objectValue;
            IFactory factory = type -> {
                try {
                    switch (type) {
                        case "contacts": {
                            ExtraContacts object = new ExtraContacts();
                            object.setValue(new ContactString(value));
                            return object;
                        }
                        case "terms_of_use": {
                            ExtraLicense object = new ExtraLicense();
                            License result = (License)this.objectUnmarshallerFactory.create(License.class).unmarshal(value);
                            object.setValue(result);
                            return object;
                        }
                        case "dates": {
                            ExtraDates object = new ExtraDates();
                            object.setValue(new DateString(value));
                            return object;
                        }
                        case "spatial_reference": {
                            ExtraSpatialReference object = new ExtraSpatialReference();
                            if (Objects.equals(value.trim(), "{}")) {
                                return object;
                            }
                            SpatialReference result = (SpatialReference)this.objectUnmarshallerFactory.create(SpatialReference.class).unmarshal(value);
                            object.setValue(result);
                            return object;
                        }
                        case "spatial": {
                            ExtraGeometry object = new ExtraGeometry();
                            object.setValue(new SpatialGeometryString(value));
                            return object;
                        }
                    }
                    ExtraString object = new ExtraString();
                    object.setValue(value);
                    return object;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, "key '" + key + "' value '" + value + "', " + exception.getMessage(), (Throwable)exception);
                    ExtraString object = new ExtraString();
                    object.setValue(value);
                    return object;
                }
            };
            Extra object = (Extra)factory.create((Object)key);
            object.setKey(key);
            return object;
        }
        Extra object = new Extra();
        object.setKey(key);
        object.getValue();
        return object;
    }
}

