/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import net.anwiba.commons.datasource.connection.IHttpConnectionDescription;
import net.anwiba.commons.http.IObjectRequestExecutor;
import net.anwiba.commons.http.IObjectRequestExecutorBuilderFactory;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.json.schema.v1_0.License;
import net.anwiba.spatial.ckan.json.schema.v1_0.PackageSearchResultResponse;
import net.anwiba.spatial.ckan.json.schema.v1_0.PackageShowResultResponse;
import net.anwiba.spatial.ckan.marshaller.CkanJsonResponseUnmarshallerFactory;
import net.anwiba.spatial.ckan.query.IFormatsNameConverter;
import net.anwiba.spatial.ckan.query.IPackageQueryExecutor;
import net.anwiba.spatial.ckan.query.IPackageSearchCondition;
import net.anwiba.spatial.ckan.query.IPackageSearchResult;
import net.anwiba.spatial.ckan.query.PackageSearchResult;
import net.anwiba.spatial.ckan.request.PackageRequestBuilder;
import net.anwiba.spatial.ckan.request.sort.ISortOrder;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;
import net.anwiba.spatial.ckan.values.Envelope;

public class PackageQueryExecutor
implements IPackageQueryExecutor {
    private final IObjectRequestExecutorBuilderFactory requestExecutorBuilderFactory;
    private final IFormatsNameConverter formatsNameConverter;

    public PackageQueryExecutor(IObjectRequestExecutorBuilderFactory requestExecutorBuilderFactory, IFormatsNameConverter formatsNameConverter) {
        this.requestExecutorBuilderFactory = requestExecutorBuilderFactory;
        this.formatsNameConverter = formatsNameConverter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPackageSearchResult query(ICanceler canceler, IHttpConnectionDescription description, IPackageSearchCondition condition) throws CanceledException, IOException {
        IResultProducer responseProducer = (c, statusCode, statusMessage, contentType, contentEncoding, inputStream) -> (PackageSearchResultResponse)new CkanJsonResponseUnmarshallerFactory().create(PackageSearchResultResponse.class).unmarshal(inputStream);
        PackageRequestBuilder.PackageSearchRequestBuilder requestBuilder = PackageRequestBuilder.search(description.getUrl()).authentication(description.getUserName(), description.getPassword());
        Streams.of((Iterable)description.getParameters().parameters()).foreach(p -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.parameter((IParameter)p);
        });
        requestBuilder.start(condition.getOffset()).rows(condition.getRows());
        condition.getOrganizations().forEach(v -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.organization(v.getName().toString());
        });
        condition.getLicenses().forEach(v -> {
            IOptional iOptional = Optional.of((Object)this.getLicenseTitle((License)v)).consume(t -> {
                PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.license((String)t);
            });
        });
        condition.getTags().forEach(v -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.tags(v.getName().toString());
        });
        condition.getGroups().forEach(v -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.group(v.getName().toString());
        });
        condition.getFormats().forEach(v -> this.formatsNameConverter.convert((String)v).forEach(f -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.resourceFormat((String)f);
        }));
        requestBuilder.event(condition.getEvent(), condition.getFromDate(), condition.getToDate());
        Optional.of((Object)condition.getEnvelope()).consume(e -> requestBuilder.envelope((Envelope)e));
        Optional.of((Object)condition.getSortOrder()).consume(e -> {
            PackageRequestBuilder.PackageSearchRequestBuilder packageSearchRequestBuilder2 = requestBuilder.sortOrder((ISortOrder)e);
        });
        requestBuilder.query(StringUtilities.isNullOrTrimmedEmpty((String)condition.getQueryString()) ? null : condition.getQueryString());
        IRequest request = requestBuilder.build();
        Throwable throwable = null;
        Object var8_9 = null;
        try (IObjectRequestExecutor executor = this.requestExecutorBuilderFactory.create().setResultProducer(responseProducer).addResultProducer((statusCode1, contentType1) -> new HashSet<Integer>(Arrays.asList(409, 400, 500)).contains(statusCode1) && contentType1 != null && contentType1.startsWith("application/json"), responseProducer).build();){
            PackageSearchResultResponse response = (PackageSearchResultResponse)executor.execute(canceler, request);
            return response.isSuccess() != false ? new PackageSearchResult(Arrays.asList(response.getResult().getResults()), response.getResult().getCount()) : new PackageSearchResult(response.getError().getMessage());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPackageSearchResult query(ICanceler canceler, IHttpConnectionDescription description, String identifier) throws CanceledException, IOException {
        IResultProducer responseProducer = (c, statusCode, statusMessage, contentType, contentEncoding, inputStream) -> (PackageShowResultResponse)new CkanJsonResponseUnmarshallerFactory().create(PackageShowResultResponse.class).unmarshal(inputStream);
        IRequest request = PackageRequestBuilder.show(description.getUrl()).identifier(identifier).authentication(description.getUserName(), description.getPassword()).build();
        Throwable throwable = null;
        Object var7_8 = null;
        try (IObjectRequestExecutor executor = this.requestExecutorBuilderFactory.create().setResultProducer(responseProducer).addResultProducer((statusCode1, contentType1) -> new HashSet<Integer>(Arrays.asList(409, 400, 500)).contains(statusCode1) && contentType1 != null && contentType1.startsWith("application/json"), responseProducer).build();){
            PackageShowResultResponse response = (PackageShowResultResponse)executor.execute(canceler, request);
            return response.isSuccess() != false ? new PackageSearchResult(Arrays.asList(response.getResult()), 1) : new PackageSearchResult(response.getError().getMessage());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private String getLicenseTitle(License license) {
        return (String)Optional.of((Object)license).convert(l -> l.getId()).or(() -> CkanUtilities.toString(license)).get();
    }
}

