//Copyright (c) 2017 by Andreas W. Bartels (bartels@anwiba.de)
package net.anwiba.spatial.ckan.json.schema.v1_0;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;

public class Facets {

    private final Map<String, Object> _unknownMembers = new LinkedHashMap<String, Object>();

    @JsonAnySetter
    public void set(final String name, final Object value) {
        Objects.requireNonNull(name);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

}
