//Copyright (c) 2017 by Andreas W. Bartels (bartels@anwiba.de)
package net.anwiba.spatial.ckan.json.schema.v1_0;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ShapeInfoString {

    private String value = null;

    public ShapeInfoString(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public net.anwiba.spatial.ckan.json.schema.v1_0.ShapeInfo asShapeInfo() {
        try {
            return new ObjectMapper().readerFor(net.anwiba.spatial.ckan.json.schema.v1_0.ShapeInfo.class).readValue(value);
        } catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static ShapeInfoString valueOf(net.anwiba.spatial.ckan.json.schema.v1_0.ShapeInfo object) {
        try {
            return new ShapeInfoString(new ObjectMapper().writerFor(net.anwiba.spatial.ckan.json.schema.v1_0.ShapeInfo.class).writeValueAsString(object));
        } catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

}
