//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.ckan.json.schema.v1_0;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Contact {

    private String role = null;
    private String name = null;
    private String email = null;
    private String address = null;
    private final Map<java.lang.String, Object> _unknownMembers = new LinkedHashMap<java.lang.String, Object>();

    @JsonProperty("role")
    public void setRole(final String role) {
        this.role = role;
    }

    @JsonProperty("role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty("name")
    public void setName(final String name) {
        this.name = name;
    }

    @JsonProperty("name")
    public String getName() {
        return this.name;
    }

    @JsonProperty("email")
    public void setEmail(final String email) {
        this.email = email;
    }

    @JsonProperty("email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty("address")
    public void setAddress(final String address) {
        this.address = address;
    }

    @JsonProperty("address")
    public String getAddress() {
        return this.address;
    }

    @JsonAnySetter
    public void set(final java.lang.String name, final Object value) {
        Objects.requireNonNull(name);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

}
