//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.ckan.json.schema.v1_0;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Label {

    private String label = null;
    private String resource = null;
    private final Map<java.lang.String, Object> _unknownMembers = new LinkedHashMap<java.lang.String, Object>();

    @JsonProperty("label")
    public void setLabel(final String label) {
        this.label = label;
    }

    @JsonProperty("label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty("resource")
    public void setResource(final String resource) {
        this.resource = resource;
    }

    @JsonProperty("resource")
    public String getResource() {
        return this.resource;
    }

    @JsonAnySetter
    public void set(final java.lang.String name, final Object value) {
        Objects.requireNonNull(name);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

}
