/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;

public class LicenseRequestBuilder {
    public static LicenseListRequestBuilder list(String url) {
        return new LicenseListRequestBuilder(url);
    }

    public static class LicenseListRequestBuilder {
        private final String url;
        private String key = null;
        private IAuthentication authentication = null;

        private LicenseListRequestBuilder(String url) {
            this.url = url;
        }

        LicenseListRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public LicenseListRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)CkanUtilities.getBaseUrl(this.url, "license_list"));
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            return builder.build();
        }
    }
}

