/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import java.text.MessageFormat;
import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.If;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;

public class TagRequestBuilder {
    public static TagListRequestBuilder list(String url) {
        return new TagListRequestBuilder(url);
    }

    public static TagSearchRequestBuilder search(String url) {
        return new TagSearchRequestBuilder(url);
    }

    public static class TagSearchRequestBuilder {
        private final String url;
        private String key = null;
        private String query = null;
        private IAuthentication authentication = null;

        private TagSearchRequestBuilder(String url) {
            this.url = url;
        }

        public TagSearchRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TagSearchRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public TagSearchRequestBuilder query(String query) {
            this.query = query;
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)CkanUtilities.getBaseUrl(this.url, "tag_search")).query("query", this.query);
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            return builder.build();
        }
    }

    public static class TagListRequestBuilder {
        private final String url;
        private String key = null;
        private IAuthentication authentication = null;
        private boolean allFields = false;

        TagListRequestBuilder(String url) {
            this.url = url;
        }

        public TagListRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TagListRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public TagListRequestBuilder setOnlyNameField() {
            this.allFields = false;
            return this;
        }

        public TagListRequestBuilder setAllFields() {
            this.allFields = true;
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)MessageFormat.format(CkanUtilities.getBaseUrl(this.url, "tag_search"), this.url));
            If.isTrue((boolean)this.allFields).excecute(() -> builder.query("all_fields", "True"));
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            return builder.build();
        }
    }
}

