/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.utilities;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.time.SystemDateTimeUtilities;
import net.anwiba.commons.utilities.time.UserDateTimeUtilities;
import net.anwiba.commons.utilities.time.ZonedDateTimeUtilities;
import net.anwiba.spatial.ckan.json.schema.v1_0.Named;
import net.anwiba.spatial.ckan.json.types.DateString;
import net.anwiba.spatial.ckan.json.types.I18String;
import net.anwiba.spatial.ckan.values.Envelope;

public class CkanUtilities {
    public static String toString(Envelope envelope) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body><p>");
        builder.append(envelope.getMinX());
        builder.append(" ");
        builder.append(envelope.getMinY());
        builder.append("</p><p>");
        builder.append(envelope.getMaxX());
        builder.append(" ");
        builder.append(envelope.getMaxY());
        builder.append("</p></body></html>");
        return builder.toString();
    }

    public static String toString(Named named) {
        return (String)Optional.of((Object)CkanUtilities.toString(named.getDisplay_name())).or((Object)CkanUtilities.toString(named.getTitle())).or((Object)CkanUtilities.toString(named.getName())).or((Object)CkanUtilities.toString(named.getDescription())).get();
    }

    public static String toString(I18String string) {
        return (String)Optional.of((Object)string).convert(v -> v.toString()).accept(n -> !StringUtilities.isNullOrEmpty((String)n)).get();
    }

    public static String toString(DateString dateString) {
        return (String)Optional.of((Object)dateString).convert(v -> v.getLocalDateTime()).convert(d -> CkanUtilities.toString(d)).getOr(() -> "");
    }

    public static String toUserTimeString(DateString dateString) {
        return (String)Optional.of((Object)dateString).convert(v -> v.getLocalDateTime()).convert(d -> CkanUtilities.toString(UserDateTimeUtilities.atUserZone((LocalDateTime)d, (ZoneId)ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone()))).getOr(() -> "");
    }

    public static String toString(LocalDateTime d) {
        return SystemDateTimeUtilities.toStringAtUserTimeZone((LocalDateTime)d);
    }

    public static String getBaseUrl(String url, String command) {
        if (url.endsWith("/api")) {
            return MessageFormat.format("{0}/3/action/{1}", url, command);
        }
        return MessageFormat.format("{0}/{1}", url, command);
    }
}

