/*
 * #%L
 * anwiba spatial
 * %%
 * Copyright (C) 2007 - 2019 Andreas Bartels
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */

package net.anwiba.spatial.ckan.marshaller;

import net.anwiba.commons.json.AbstractJsonObjectsUnmarshaller;
import net.anwiba.commons.lang.map.HashMapBuilder;
import net.anwiba.spatial.ckan.json.factory.ExtraValueFactory;
import net.anwiba.spatial.ckan.json.schema.v1_0.Response;

public class CkanJsonObjectsUnmarshaller<T> extends
    AbstractJsonObjectsUnmarshaller<T, Response, CkanJsonMapperException> {

  public CkanJsonObjectsUnmarshaller(final Class<T> clazz) {
    super(
        clazz,
        Response.class,
        new HashMapBuilder<String, Object>().put("extravaluefactory", new ExtraValueFactory()).build(), //$NON-NLS-1$
        new CkanJsonMapperExceptionFactory());
  }

}
