/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.query;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.spatial.ckan.json.schema.v1_0.Group;
import net.anwiba.spatial.ckan.json.schema.v1_0.License;
import net.anwiba.spatial.ckan.json.schema.v1_0.Organization;
import net.anwiba.spatial.ckan.json.schema.v1_0.Tag;
import net.anwiba.spatial.ckan.query.IPackageSearchCondition;
import net.anwiba.spatial.ckan.query.IPackageSearchConditionBuilder;
import net.anwiba.spatial.ckan.query.PackageSearchCondition;
import net.anwiba.spatial.ckan.request.sort.ISortOrder;
import net.anwiba.spatial.ckan.request.sort.Order;
import net.anwiba.spatial.ckan.request.sort.SortOrderTerm;
import net.anwiba.spatial.ckan.request.time.Event;
import net.anwiba.spatial.ckan.values.Envelope;

public class PackageSearchConditionBuilder
implements IPackageSearchConditionBuilder {
    private int offset = 0;
    private int rows = 10;
    private String queryString;
    private Envelope envelope;
    private LocalDateTime fromDate;
    private LocalDateTime toDate;
    private final List<Organization> organizations = new ArrayList<Organization>();
    private final List<Group> groups = new ArrayList<Group>();
    private final List<Tag> tags = new ArrayList<Tag>();
    private final List<String> formats = new ArrayList<String>();
    private final List<License> licenses = new ArrayList<License>();
    private ISortOrder sortOrder;
    private Event event;

    public PackageSearchConditionBuilder() {
    }

    public PackageSearchConditionBuilder(IPackageSearchCondition condition) {
        if (condition == null) {
            return;
        }
        this.queryString = condition.getQueryString();
        this.envelope = condition.getEnvelope();
        this.fromDate = condition.getFromDate();
        this.toDate = condition.getToDate();
        condition.getOrganizations().forEach(v -> this.organizations.add((Organization)v));
        condition.getGroups().forEach(v -> this.groups.add((Group)v));
        condition.getTags().forEach(v -> this.tags.add((Tag)v));
        condition.getFormats().forEach(v -> this.formats.add((String)v));
        condition.getLicenses().forEach(v -> this.licenses.add((License)v));
    }

    @Override
    public IPackageSearchCondition build() {
        return new PackageSearchCondition(this.queryString, this.envelope, this.event, this.fromDate, this.toDate, this.organizations, this.groups, this.tags, this.formats, this.licenses, this.offset, this.rows, this.sortOrder);
    }

    @Override
    public IPackageSearchConditionBuilder setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setRows(int rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setFormats(List<String> formats) {
        this.formats.addAll(formats);
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setGroups(List<Group> groups) {
        this.groups.addAll(groups);
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setTags(List<Tag> tags) {
        this.tags.addAll(tags);
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setOrganizations(List<Organization> organizations) {
        this.organizations.addAll(organizations);
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setLicenses(List<License> licenses) {
        this.licenses.addAll(licenses);
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setQuery(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setEvent(Event event) {
        this.event = event;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setCreated() {
        this.event = Event.CREATED;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setModified() {
        this.event = Event.MODIFIED;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setEnvelope(double minX, double minY, double maxX, double maxY) {
        this.envelope = new Envelope(minX, minY, maxX, maxY);
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setEnvelope(Envelope envelope) {
        this.envelope = envelope;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setSortOrder(ISortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @Override
    public IPackageSearchConditionBuilder setCreatedDescentOrder() {
        return this.setSortOrder(new SortOrderTerm(Order.asc, "metadata_created"));
    }

    @Override
    public IPackageSearchConditionBuilder setCreatedAscentOrder() {
        return this.setSortOrder(new SortOrderTerm(Order.asc, "metadata_created"));
    }

    @Override
    public IPackageSearchConditionBuilder setModifiedDescentOrder() {
        return this.setSortOrder(new SortOrderTerm(Order.desc, "metadata_modified"));
    }

    @Override
    public IPackageSearchConditionBuilder setModifiedAscentOrder() {
        return this.setSortOrder(new SortOrderTerm(Order.asc, "metadata_modified"));
    }
}

