/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.If;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;

public class GroupRequestBuilder {
    public static GroupListRequestBuilder list(String url) {
        return new GroupListRequestBuilder(url);
    }

    public static class GroupListRequestBuilder {
        private final String url;
        private String key = null;
        private IAuthentication authentication = null;
        private int limit = -1;
        private boolean allFields = false;

        private GroupListRequestBuilder(String url) {
            this.url = url;
        }

        public GroupListRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public GroupListRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public GroupListRequestBuilder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public GroupListRequestBuilder setOnlyNameField() {
            this.allFields = false;
            return this;
        }

        public GroupListRequestBuilder setAllFields() {
            this.allFields = true;
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)CkanUtilities.getBaseUrl(this.url, "group_list"));
            If.isTrue((this.limit > 0 ? 1 : 0) != 0).excecute(() -> builder.query("limit", String.valueOf(this.limit)));
            If.isTrue((boolean)this.allFields).excecute(() -> builder.query("all_fields", "True"));
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            return builder.build();
        }
    }
}

