/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.If;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;

public class OrganizationRequestBuilder {
    public static OrganizationShowRequestBuilder show(String url) {
        return new OrganizationShowRequestBuilder(url);
    }

    public static OrganizationListRequestBuilder list(String url) {
        return new OrganizationListRequestBuilder(url);
    }

    public static class OrganizationListRequestBuilder {
        private final String url;
        private String key = null;
        private IAuthentication authentication = null;
        private int limit = -1;
        private boolean allFields = false;
        private boolean extras = false;

        private OrganizationListRequestBuilder(String url) {
            this.url = url;
        }

        public OrganizationListRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public OrganizationListRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public OrganizationListRequestBuilder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public OrganizationListRequestBuilder setOnlyNameField() {
            this.allFields = false;
            this.extras = false;
            return this;
        }

        public OrganizationListRequestBuilder setAllFields() {
            this.allFields = true;
            return this;
        }

        public OrganizationListRequestBuilder setExtraFields() {
            this.extras = true;
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)CkanUtilities.getBaseUrl(this.url, "organization_list"));
            If.isTrue((this.limit > 0 ? 1 : 0) != 0).excecute(() -> builder.query("limit", String.valueOf(this.limit)));
            If.isTrue((boolean)this.allFields).excecute(() -> builder.query("all_fields", "True"));
            If.isTrue((boolean)this.extras).excecute(() -> builder.query("include_extras", "True"));
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            return builder.build();
        }
    }

    public static class OrganizationShowRequestBuilder {
        private final String url;
        private String identifier;
        private Authentication authentication;
        private String key;

        public OrganizationShowRequestBuilder(String url) {
            this.url = url;
        }

        public OrganizationShowRequestBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public OrganizationShowRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public OrganizationShowRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)CkanUtilities.getBaseUrl(this.url, "organization_show"));
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            Optional.of((Object)this.identifier).consume(a -> builder.query("id", this.identifier));
            return builder.build();
        }
    }
}

