/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.ckan.request;

import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.RequestBuilder;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.ckan.utilities.CkanUtilities;

public class ResourceFormatRequestBuilder {
    public static ResourceFormatListRequestBuilder list(String url) {
        return new ResourceFormatListRequestBuilder(url);
    }

    public static class ResourceFormatListRequestBuilder {
        private final String url;
        private String key = null;
        private IAuthentication authentication = null;
        private String stringPart = "";
        private int limit = 5;

        private ResourceFormatListRequestBuilder(String url) {
            this.url = url;
        }

        public ResourceFormatListRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public ResourceFormatListRequestBuilder authentication(String userName, String password) {
            if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
                return this;
            }
            this.authentication = new Authentication(userName, password);
            return this;
        }

        public ResourceFormatListRequestBuilder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public ResourceFormatListRequestBuilder setSearchStringPart(String string) {
            this.stringPart = string;
            return this;
        }

        public IRequest build() throws CreationException {
            RequestBuilder builder = RequestBuilder.get((String)CkanUtilities.getBaseUrl(this.url, "format_autocomplete")).query("q", this.stringPart).query("limit", String.valueOf(this.limit));
            Optional.of((Object)this.key).convert(k -> builder.header("X-CKAN-API-Key", k));
            Optional.of((Object)this.authentication).consume(a -> builder.authentication(a.getUsername(), a.getPassword()));
            return builder.build();
        }
    }
}

