//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.ckan.json.schema.v1_0;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ExtraSpatialReference
    extends Extra
{

    private SpatialReference value = null;
    private final Map<String, Object> _unknownMembers = new LinkedHashMap<>();

    @JsonProperty("value")
    public void setValue(final SpatialReference value) {
        this.value = value;
    }

    @JsonProperty("value")
    public SpatialReference getValue() {
        return this.value;
    }

    @JsonAnySetter
    public void set(final String name, final Object value) {
        Objects.requireNonNull(name);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

}
