//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.ckan.json.schema.v1_0;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ExtraString
    extends Extra
{

    private String value = null;
    private final Map<java.lang.String, Object> _unknownMembers = new LinkedHashMap<>();

    @JsonProperty("value")
    public void setValue(final String value) {
        this.value = value;
    }

    @JsonProperty("value")
    public String getValue() {
        return this.value;
    }

    @JsonAnySetter
    public void set(final java.lang.String name, final Object value) {
        Objects.requireNonNull(name);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

}
