//// Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.gps.gpsd.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "class")
@JsonSubTypes({
    @JsonSubTypes.Type(Device.class),
    @JsonSubTypes.Type(Devices.class),
    @JsonSubTypes.Type(Error.class),
    @JsonSubTypes.Type(Gst.class),
    @JsonSubTypes.Type(Poll.class),
    @JsonSubTypes.Type(Sky.class),
    @JsonSubTypes.Type(Tpv.class),
    @JsonSubTypes.Type(Version.class),
    @JsonSubTypes.Type(Watch.class)
})
public class Response {

    private final String _class = null;

    @JsonIgnore
    public void setClass(final String _class) {
    }

    @JsonIgnore
    public String getCLASS() {
        return this._class;
    }

}
