//// Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.gps.gpsd.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Tpv
    extends Response
{

    private final String _class = "TPV";
    private String tag = null;
    private String device = null;
    private Integer mode = Integer.valueOf(0);
    private String time = null;
    private Double ept = null;
    private Double lat = null;
    private Double lon = null;
    private Double alt = null;
    private Double epx = null;
    private Double epy = null;
    private Double epv = null;
    private Double track = null;
    private Double speed = null;
    private Double climb = null;
    private Double epd = null;
    private Double eps = null;
    private Double epc = null;

    @JsonIgnore
    public void setClass(final String _class) {
    }

    @JsonIgnore
    public String getCLASS() {
        return this._class;
    }

    @JsonProperty("tag")
    public void setTag(final String tag) {
        this.tag = tag;
    }

    @JsonProperty("tag")
    public String getTag() {
        return this.tag;
    }

    @JsonProperty("device")
    public void setDevice(final String device) {
        this.device = device;
    }

    @JsonProperty("device")
    public String getDevice() {
        return this.device;
    }

    @JsonProperty("mode")
    public void setMode(final Integer mode) {
        this.mode = mode;
    }

    @JsonProperty("mode")
    public Integer getMode() {
        return this.mode;
    }

    @JsonProperty("time")
    public void setTime(final String time) {
        this.time = time;
    }

    @JsonProperty("time")
    public String getTime() {
        return this.time;
    }

    @JsonProperty("ept")
    public void setEpt(final Double ept) {
        this.ept = ept;
    }

    @JsonProperty("ept")
    public Double getEpt() {
        return this.ept;
    }

    @JsonProperty("lat")
    public void setLat(final Double lat) {
        this.lat = lat;
    }

    @JsonProperty("lat")
    public Double getLat() {
        return this.lat;
    }

    @JsonProperty("lon")
    public void setLon(final Double lon) {
        this.lon = lon;
    }

    @JsonProperty("lon")
    public Double getLon() {
        return this.lon;
    }

    @JsonProperty("alt")
    public void setAlt(final Double alt) {
        this.alt = alt;
    }

    @JsonProperty("alt")
    public Double getAlt() {
        return this.alt;
    }

    @JsonProperty("epx")
    public void setEpx(final Double epx) {
        this.epx = epx;
    }

    @JsonProperty("epx")
    public Double getEpx() {
        return this.epx;
    }

    @JsonProperty("epy")
    public void setEpy(final Double epy) {
        this.epy = epy;
    }

    @JsonProperty("epy")
    public Double getEpy() {
        return this.epy;
    }

    @JsonProperty("epv")
    public void setEpv(final Double epv) {
        this.epv = epv;
    }

    @JsonProperty("epv")
    public Double getEpv() {
        return this.epv;
    }

    @JsonProperty("track")
    public void setTrack(final Double track) {
        this.track = track;
    }

    @JsonProperty("track")
    public Double getTrack() {
        return this.track;
    }

    @JsonProperty("speed")
    public void setSpeed(final Double speed) {
        this.speed = speed;
    }

    @JsonProperty("speed")
    public Double getSpeed() {
        return this.speed;
    }

    @JsonProperty("climb")
    public void setClimb(final Double climb) {
        this.climb = climb;
    }

    @JsonProperty("climb")
    public Double getClimb() {
        return this.climb;
    }

    @JsonProperty("epd")
    public void setEpd(final Double epd) {
        this.epd = epd;
    }

    @JsonProperty("epd")
    public Double getEpd() {
        return this.epd;
    }

    @JsonProperty("eps")
    public void setEps(final Double eps) {
        this.eps = eps;
    }

    @JsonProperty("eps")
    public Double getEps() {
        return this.eps;
    }

    @JsonProperty("epc")
    public void setEpc(final Double epc) {
        this.epc = epc;
    }

    @JsonProperty("epc")
    public Double getEpc() {
        return this.epc;
    }

}
