//// Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.gps.gpsd.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Watch
    extends Response
{

    private final String _class = "WATCH";
    private boolean enable = false;
    private boolean json = false;
    private boolean nmea = false;
    private int raw = 0;
    private boolean scaled = false;
    private boolean timing = false;
    private String device = null;
    private String remote = null;

    @JsonIgnore
    public void setClass(final String _class) {
    }

    @JsonIgnore
    public String getCLASS() {
        return this._class;
    }

    @JsonProperty("enable")
    public void setEnable(final boolean enable) {
        this.enable = enable;
    }

    @JsonProperty("enable")
    public boolean isEnable() {
        return this.enable;
    }

    @JsonProperty("json")
    public void setJson(final boolean json) {
        this.json = json;
    }

    @JsonProperty("json")
    public boolean isJson() {
        return this.json;
    }

    @JsonProperty("nmea")
    public void setNmea(final boolean nmea) {
        this.nmea = nmea;
    }

    @JsonProperty("nmea")
    public boolean isNmea() {
        return this.nmea;
    }

    @JsonProperty("raw")
    public void setRaw(final int raw) {
        this.raw = raw;
    }

    @JsonProperty("raw")
    public int getRaw() {
        return this.raw;
    }

    @JsonProperty("scaled")
    public void setScaled(final boolean scaled) {
        this.scaled = scaled;
    }

    @JsonProperty("scaled")
    public boolean isScaled() {
        return this.scaled;
    }

    @JsonProperty("timing")
    public void setTiming(final boolean timing) {
        this.timing = timing;
    }

    @JsonProperty("timing")
    public boolean isTiming() {
        return this.timing;
    }

    @JsonProperty("device")
    public void setDevice(final String device) {
        this.device = device;
    }

    @JsonProperty("device")
    public String getDevice() {
        return this.device;
    }

    @JsonProperty("remote")
    public void setRemote(final String remote) {
        this.remote = remote;
    }

    @JsonProperty("remote")
    public String getRemote() {
        return this.remote;
    }

}
