/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.gps.gpsd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.spatial.gps.gpsd.Connection;
import net.anwiba.spatial.gps.gpsd.GpsDevice;
import net.anwiba.spatial.gps.gpsd.IGpsDevice;
import net.anwiba.spatial.gps.gpsd.IGpsdFacade;
import net.anwiba.spatial.gps.gpsd.response.Device;
import net.anwiba.spatial.gps.gpsd.response.Poll;
import net.anwiba.spatial.gps.gpsd.response.Tpv;
import net.anwiba.spatial.gps.gpsd.response.Version;

public class GpsdFacade
implements IGpsdFacade {
    private static final ILogger logger = Logging.getLogger((String)GpsdFacade.class.getName());
    private final String host;
    private final int port;
    private final int timeout;

    public static void main(String[] args) {
        GpsdFacade client = new GpsdFacade();
        try {
            Iterable<IGpsDevice> gpsDevices = client.devices();
            String deviceName = (String)Streams.create(gpsDevices).first(d -> "/dev/ttyUSB0".equals(d.getPath())).convert(d -> d.getPath()).getOr(() -> (String)Optional.create(gpsDevices.iterator()).accept(i -> i.hasNext()).convert(i -> ((IGpsDevice)i.next()).getPath()).getOrThrow((Exception)new IOException("Couldn't find any device")));
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = client.connect();){
                int i = 0;
                while (i < 30) {
                    Tpv[] tpvs;
                    Poll poll = connection.poll();
                    Tpv[] tpvArray = tpvs = poll.getTpv();
                    int n = tpvs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tpv tpv = tpvArray[n2];
                        StringBuilder builder = new StringBuilder();
                        builder.append("time: ");
                        builder.append(tpv.getTime());
                        builder.append(", device:");
                        builder.append(tpv.getDevice());
                        builder.append(", mode: ");
                        builder.append(MessageFormat.format("{0,number,#0}", tpv.getMode()));
                        builder.append(", latitude: ");
                        builder.append(MessageFormat.format("{0,number,##0.0000000}", tpv.getLat()));
                        builder.append(", longitude: ");
                        builder.append(MessageFormat.format("{0,number,##0.0000000}", tpv.getLon()));
                        builder.append(", altitude: ");
                        builder.append(MessageFormat.format("{0,number,##0.000}", tpv.getAlt()));
                        System.out.println(builder.toString());
                        ++n2;
                    }
                    Thread.sleep(500L);
                    ++i;
                }
                connection.watch(false, deviceName);
                connection.poll();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.log(ILevel.ERROR, e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public GpsdFacade() {
        this("localhost", 2947, 10000);
    }

    public GpsdFacade(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public Connection connect() throws IOException {
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(this.timeout);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        Connection connection = new Connection(socket, in, out);
        connection.recieve(Version.class);
        return connection;
    }

    @Override
    public Iterable<IGpsDevice> devices() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection connection = this.connect();){
            ArrayList<IGpsDevice> result = new ArrayList<IGpsDevice>();
            for (Device device : connection.devices()) {
                String path = device.getPath();
                result.add(new GpsDevice(this, path));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IGpsDevice device(String path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            GpsDevice gpsDevice;
            Connection connection = this.connect();
            try {
                Device device;
                Iterator<Device> iterator = connection.devices().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    throw new NoSuchElementException();
                } while (!Objects.equals(path, (device = iterator.next()).getPath()));
                gpsDevice = new GpsDevice(this, path);
                return gpsDevice;
            }
            finally {
                if (connection == null) return gpsDevice;
                connection.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public Version version() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection connection = this.connect();){
            return connection.version();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

