/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.gps.gpsd;

import java.io.IOException;
import java.util.NoSuchElementException;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.utilities.io.IClosableIterator;
import net.anwiba.spatial.gps.gpsd.Connection;
import net.anwiba.spatial.gps.gpsd.GpsdFacade;
import net.anwiba.spatial.gps.gpsd.IGpsDevice;
import net.anwiba.spatial.gps.gpsd.IRecord;
import net.anwiba.spatial.gps.gpsd.Record;
import net.anwiba.spatial.gps.gpsd.response.Devices;
import net.anwiba.spatial.gps.gpsd.response.Poll;
import net.anwiba.spatial.gps.gpsd.response.Tpv;
import net.anwiba.spatial.gps.gpsd.response.Watch;

public final class GpsDevice
implements IGpsDevice {
    private final GpsdFacade gpsdFacade;
    private final String path;

    public GpsDevice(GpsdFacade gpsdFacade, String path) {
        this.gpsdFacade = gpsdFacade;
        this.path = path;
    }

    @Override
    public IClosableIterator<IRecord, IOException> records() throws IOException {
        final Connection connection = this.gpsdFacade.connect();
        return new IClosableIterator<IRecord, IOException>(){
            IRecord record = null;

            public void close() throws IOException {
                connection.close();
            }

            public IRecord next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    IRecord iRecord = this.record;
                    return iRecord;
                }
                finally {
                    this.record = null;
                }
            }

            public boolean hasNext() throws IOException {
                ObjectPair<Devices, Watch> watch = connection.watch(false, GpsDevice.this.path);
                if (!((Watch)watch.getSecondObject()).isEnable()) {
                    return false;
                }
                Poll poll = connection.poll();
                Tpv[] tpvs = poll.getTpv();
                if (tpvs.length == 0) {
                    return false;
                }
                Tpv tpv = tpvs[0];
                this.record = new Record(tpv.getTime(), tpv.getMode(), tpv.getLat(), tpv.getLon(), tpv.getAlt());
                return true;
            }
        };
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

