//// Copyright (c) 2017 by Andreas W. Bartels (bartels@anwiba.de)
package net.anwiba.spatial.gps.gpsd.response;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;

public class Response {

    private String _class = null;
    private final static HashMap<String, Class> _classes = new HashMap<String, Class>();

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public static Response create(
        @JsonProperty("class")
        String _class) {
        if (_isNullOrTrimmedEmpty(_class)) {
            return new Response();
        }
        Class<? extends Response> clazz = _createClass(_class);
        if (clazz!= null) {
            return _createBean(clazz);
        }
        clazz = _createClass(_class.toLowerCase());
        if (clazz!= null) {
            return _createBean(clazz);
        }
        String className = MessageFormat.format("{0}{1}", _class, "Response");
        clazz = _createClass(className);
        if (clazz!= null) {
            return _createBean(clazz);
        }
        className = MessageFormat.format("{0}{1}", _class.toLowerCase(), "Response");
        clazz = _createClass(className);
        if (clazz!= null) {
            return _createBean(clazz);
        }
        return new Response();
    }

    private static Response _createBean(Class<? extends Response> clazz) {
        try {
            ReflectionConstructorInvoker<Response> invoker = new ReflectionConstructorInvoker<Response>(clazz);
            return invoker.invoke();
        } catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static synchronized Class<? extends Response> _createClass(String type) {
        if (_classes.containsKey(type)) {
            return ((Class<? extends Response> ) _classes.get(type));
        }
        try {
            String packageName = Response.class.getPackage().getName();
            String typeName = _setFirstCharacterToUpperCase(type);
            String className = MessageFormat.format("{0}.{1}", packageName, typeName);
            Class<?> clazz = Class.forName(className);
            if (!Response.class.isAssignableFrom(clazz)) {
                _classes.put(type, null);
                return null;
            }
            _classes.put(type, clazz);
            return ((Class<? extends Response> ) clazz);
        } catch (ClassNotFoundException exception) {
            _classes.put(type, null);
            return null;
        }
    }

    private static boolean _isNullOrTrimmedEmpty(String value) {
        return ((value == null)||value.trim().isEmpty());
    }

    private static String _setFirstCharacterToUpperCase(String value) {
        if ((value == null)||value.trim().isEmpty()) {
            return null;
        }
        return (value.substring(0, 1).toUpperCase()+ value.substring(1, value.length()));
    }

    @JsonProperty("class")
    public String getCLASS() {
        return this._class;
    }

}
