/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.gps.gpsd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.logging.LoggingUtilities;
import net.anwiba.spatial.gps.gpsd.Connection;
import net.anwiba.spatial.gps.gpsd.GpsDevice;
import net.anwiba.spatial.gps.gpsd.IGpsDevice;
import net.anwiba.spatial.gps.gpsd.IGpsdFacade;
import net.anwiba.spatial.gps.gpsd.response.Device;
import net.anwiba.spatial.gps.gpsd.response.Poll;
import net.anwiba.spatial.gps.gpsd.response.Tpv;
import net.anwiba.spatial.gps.gpsd.response.Version;

public class GpsdFacade
implements IGpsdFacade {
    private static final ILogger logger = Logging.getLogger((String)GpsdFacade.class.getName());
    private final String host;
    private final int port;
    private final int timeout;

    public static void main(String[] args) {
        LoggingUtilities.initialize((String)ILevel.DEBUG.getName(), (String[])new String[0]);
        GpsdFacade client = new GpsdFacade();
        try {
            Iterable<IGpsDevice> gpsDevices = client.devices();
            String deviceName = (String)Streams.of(IOException.class, gpsDevices).first(d -> "/dev/ttyUSB0".equals(d.getPath())).convert(d -> d.getPath()).getOr(() -> (String)Optional.of(IOException.class, gpsDevices.iterator()).accept(i -> i.hasNext()).convert(i -> ((IGpsDevice)i.next()).getPath()).getOrThrow(() -> new IOException("Couldn't find any device")));
            try (Connection connection = client.connect();){
                for (int i = 0; i < 30; ++i) {
                    Tpv[] tpvs;
                    Poll poll = connection.poll();
                    for (Tpv tpv : tpvs = poll.getTpv()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("time: ");
                        builder.append(tpv.getTime());
                        builder.append(", device:");
                        builder.append(tpv.getDevice());
                        builder.append(", mode: ");
                        builder.append(MessageFormat.format("{0,number,#0}", tpv.getMode()));
                        builder.append(", latitude: ");
                        builder.append(MessageFormat.format("{0,number,##0.0000000}", tpv.getLat()));
                        builder.append(", longitude: ");
                        builder.append(MessageFormat.format("{0,number,##0.0000000}", tpv.getLon()));
                        builder.append(", altitude: ");
                        builder.append(MessageFormat.format("{0,number,##0.000}", tpv.getAlt()));
                        System.out.println(builder.toString());
                    }
                    Thread.sleep(500L);
                }
                connection.watch(false, deviceName);
                connection.poll();
            }
        }
        catch (Exception e) {
            logger.log(ILevel.ERROR, e.toString());
            logger.log(ILevel.ERROR, e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public GpsdFacade() {
        this("localhost", 2947, 10000);
    }

    public GpsdFacade(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public Connection connect() throws IOException {
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(this.timeout);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        Connection connection = new Connection(socket, in, out);
        connection.recieve(Version.class);
        return connection;
    }

    @Override
    public Iterable<IGpsDevice> devices() throws IOException {
        try (Connection connection = this.connect();){
            ArrayList<GpsDevice> result = new ArrayList<GpsDevice>();
            for (Device device : connection.devices()) {
                String path = device.getPath();
                result.add(new GpsDevice(this, path));
            }
            ArrayList<GpsDevice> arrayList = result;
            return arrayList;
        }
    }

    @Override
    public IGpsDevice device(String path) throws IOException {
        try (Connection connection = this.connect();){
            for (Device device : connection.devices()) {
                if (!Objects.equals(path, device.getPath())) continue;
                GpsDevice gpsDevice = new GpsDevice(this, path);
                return gpsDevice;
            }
            throw new NoSuchElementException();
        }
    }

    @Override
    public Version version() throws IOException {
        try (Connection connection = this.connect();){
            Version version = connection.version();
            return version;
        }
    }
}

