/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.gps.gpsd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import net.anwiba.commons.json.JsonObjectUtilities;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.spatial.gps.gpsd.response.Device;
import net.anwiba.spatial.gps.gpsd.response.Devices;
import net.anwiba.spatial.gps.gpsd.response.Error;
import net.anwiba.spatial.gps.gpsd.response.Poll;
import net.anwiba.spatial.gps.gpsd.response.Response;
import net.anwiba.spatial.gps.gpsd.response.Version;
import net.anwiba.spatial.gps.gpsd.response.Watch;

public class Connection
implements AutoCloseable {
    private static ILogger logger = Logging.getLogger(Connection.class);
    private final Object mutex = new Object();
    private final Socket socket;
    private final BufferedReader in;
    private final BufferedWriter out;

    public Connection(Socket socket, BufferedReader in, BufferedWriter out) {
        this.socket = socket;
        this.in = in;
        this.out = out;
    }

    public ObjectPair<Devices, Watch> watch(boolean enable, String deviceName) throws IOException {
        Watch watch = new Watch();
        watch.setDevice(deviceName);
        watch.setEnable(enable);
        watch.setJson(enable);
        watch.setJson(enable);
        this.call("?WATCH=" + JsonObjectUtilities.marshall((Object)watch) + ";");
        Devices devices = this.recieve(Devices.class);
        Watch watchResponse = this.recieve(Watch.class);
        return new ObjectPair((Object)devices, (Object)watchResponse);
    }

    public Iterable<Device> devices() throws IOException {
        this.call("?DEVICES;");
        Devices devices = this.recieve(Devices.class);
        ArrayList<Device> result = new ArrayList<Device>();
        for (Device device : devices.getDevices()) {
            result.add(device);
        }
        return result;
    }

    public Version version() throws IOException {
        this.call("?VERSION;");
        return this.recieve(Version.class);
    }

    public Poll poll() throws IOException {
        this.call("?POLL;");
        return this.recieve(Poll.class);
    }

    public <T> T recieve(Class<T> clazz) throws IOException {
        try {
            String line = this.recieve();
            Response response = (Response)JsonObjectUtilities.unmarshall(Response.class, (String)line);
            if (response instanceof Error) {
                throw new IOException(((Error)response).getMessage());
            }
            if (clazz.isInstance(response)) {
                return (T)response;
            }
            throw new IOException("unexpected response '" + response.getClass().getName() + "'");
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String recieve() throws IOException {
        StringBuilder builder = new StringBuilder();
        Object object = this.mutex;
        synchronized (object) {
            builder.append(this.in.readLine());
        }
        String line = builder.toString();
        logger.log(ILevel.DEBUG, line);
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String cmd) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.out.write(cmd + "\n");
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioException = IoUtilities.close((Closeable)this.out, (Closeable)this.in, (Closeable[])new Closeable[]{this.socket});
        IoUtilities.throwIfNotNull((Throwable)ioException);
    }
}

