//Copyright (c) 2017 by Andreas W. Bartels (bartels@anwiba.de)
package net.anwiba.spatial.osm.overpass.schema.v00_6;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.reflection.OptionalReflectionMethodInvoker;

public class ErrorResponse {

    private final Map<String, Object> _unknownMembers = new LinkedHashMap<String, Object>();

    private void _inject(String name, Object value) {
        try {
            OptionalReflectionMethodInvoker<ErrorResponse, Object> setterInvoker = OptionalReflectionMethodInvoker.createSetter(this.getClass(), "JsonProperty", "value", name);
            setterInvoker.invoke(this, value);
        } catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @JsonAnySetter
    public void set(final String name, final Object value) {
        Ensure.ensureThatArgument(name, Conditions.notNull());
        _inject(name, value);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

}
