//Copyright (c) 2017 by Andreas W. Bartels (bartels@anwiba.de)
package net.anwiba.spatial.osm.overpass.schema.v00_6;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.anwiba.commons.reflection.OptionalReflectionMethodInvoker;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;

public class OverpassObject {

    private final String type = "OverpassObject";
    private Object id = null;
    private Bounds bounds = null;
    private Double lat = null;
    private Double lon = null;
    private String timestamp = null;
    private Integer version = null;
    private Integer changeset = null;
    private String user = null;
    private Object uid = null;
    private Tags tags = null;
    private final Map<java.lang.String, java.lang.Object> _unknownMembers = new LinkedHashMap<java.lang.String, java.lang.Object>();
    private final static HashMap<java.lang.String, Class> _classes = new HashMap<java.lang.String, Class>();

    @JsonProperty("type")
    public String getType() {
        return this.type;
    }

    @JsonProperty("id")
    public void setId(final Object id) {
        this.id = id;
    }

    @JsonProperty("id")
    public Object getId() {
        return this.id;
    }

    @JsonProperty("bounds")
    public void setBounds(final Bounds bounds) {
        this.bounds = bounds;
    }

    @JsonProperty("bounds")
    public Bounds getBounds() {
        return this.bounds;
    }

    @JsonProperty("lat")
    public void setLat(final Double lat) {
        this.lat = lat;
    }

    @JsonProperty("lat")
    public Double getLat() {
        return this.lat;
    }

    @JsonProperty("lon")
    public void setLon(final Double lon) {
        this.lon = lon;
    }

    @JsonProperty("lon")
    public Double getLon() {
        return this.lon;
    }

    @JsonProperty("timestamp")
    public void setTimestamp(final String timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty("timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty("version")
    public void setVersion(final Integer version) {
        this.version = version;
    }

    @JsonProperty("version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty("changeset")
    public void setChangeset(final Integer changeset) {
        this.changeset = changeset;
    }

    @JsonProperty("changeset")
    public Integer getChangeset() {
        return this.changeset;
    }

    @JsonProperty("user")
    public void setUser(final String user) {
        this.user = user;
    }

    @JsonProperty("user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty("uid")
    public void setUid(final Object uid) {
        this.uid = uid;
    }

    @JsonProperty("uid")
    public Object getUid() {
        return this.uid;
    }

    @JsonProperty("tags")
    public void setTags(final Tags tags) {
        this.tags = tags;
    }

    @JsonProperty("tags")
    public Tags getTags() {
        return this.tags;
    }

    private void _inject(java.lang.String name, java.lang.Object value) {
        try {
            OptionalReflectionMethodInvoker<OverpassObject, java.lang.Object> setterInvoker = OptionalReflectionMethodInvoker.createSetter(this.getClass(), "JsonProperty", "value", name);
            setterInvoker.invoke(this, value);
        } catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @JsonAnySetter
    public void set(final java.lang.String name, final java.lang.Object value) {
        Objects.requireNonNull(name);
        _inject(name, value);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<java.lang.String, java.lang.Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

    @JsonCreator
    public static OverpassObject create(
        @JsonProperty("type")
        java.lang.String type) {
        if (_isNullOrTrimmedEmpty(type)) {
            return new OverpassObject();
        }
        Class<? extends OverpassObject> clazz = _createClass(type);
        if (clazz!= null) {
            return _createBean(clazz);
        }
        clazz = _createClass(type.toLowerCase());
        if (clazz!= null) {
            return _createBean(clazz);
        }
        java.lang.String className = MessageFormat.format("{0}{1}", type, "OverpassObject");
        clazz = _createClass(className);
        if (clazz!= null) {
            return _createBean(clazz);
        }
        className = MessageFormat.format("{0}{1}", type.toLowerCase(), "OverpassObject");
        clazz = _createClass(className);
        if (clazz!= null) {
            return _createBean(clazz);
        }
        return new OverpassObject();
    }

    private static OverpassObject _createBean(Class<? extends OverpassObject> clazz) {
        try {
            ReflectionConstructorInvoker<OverpassObject> invoker = new ReflectionConstructorInvoker<OverpassObject>(clazz);
            return invoker.invoke();
        } catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static synchronized Class<? extends OverpassObject> _createClass(java.lang.String type) {
        if (_classes.containsKey(type)) {
            return ((Class<? extends OverpassObject> ) _classes.get(type));
        }
        try {
            java.lang.String packageName = OverpassObject.class.getPackage().getName();
            java.lang.String typeName = _setFirstCharacterToUpperCase(type);
            java.lang.String className = MessageFormat.format("{0}.{1}", packageName, typeName);
            Class<?> clazz = Class.forName(className);
            if (!OverpassObject.class.isAssignableFrom(clazz)) {
                _classes.put(type, null);
                return null;
            }
            _classes.put(type, clazz);
            return ((Class<? extends OverpassObject> ) clazz);
        } catch (ClassNotFoundException exception) {
            _classes.put(type, null);
            return null;
        }
    }

    private static boolean _isNullOrTrimmedEmpty(java.lang.String value) {
        return ((value == null)||value.trim().isEmpty());
    }

    private static java.lang.String _setFirstCharacterToUpperCase(java.lang.String value) {
        if ((value == null)||value.trim().isEmpty()) {
            return null;
        }
        return (value.substring(0, 1).toUpperCase()+ value.substring(1, value.length()));
    }

}
