//Copyright (c) 2017 by Andreas W. Bartels (bartels@anwiba.de)
package net.anwiba.spatial.osm.overpass.schema.v00_6;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import net.anwiba.commons.reflection.OptionalReflectionMethodInvoker;

public class Tags {

    private final Map<String, Object> _unknownMembers = new LinkedHashMap<String, Object>();

    private void _inject(String name, Object value) {
        try {
            OptionalReflectionMethodInvoker<Tags, Object> setterInvoker = OptionalReflectionMethodInvoker.createSetter(this.getClass(), "JsonProperty", "value", name);
            setterInvoker.invoke(this, value);
        } catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @JsonAnySetter
    public void set(final String name, final Object value) {
        Objects.requireNonNull(name);
        _inject(name, value);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

    @JsonIgnore
    public Iterable<String> getNames() {
        return this._unknownMembers.keySet();
    }

    public Object getValue(final String name) {
        if (name == null) {
            return null;
        }
        return this._unknownMembers.get(name);
    }

}
