//Copyright (c) 2017 by Andreas W. Bartels
package net.anwiba.spatial.osm.overpass.schema.v00_6;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class Tags {

    private final Map<String, Object> _unknownMembers = new LinkedHashMap<String, Object>();

    @JsonAnySetter
    public void set(final String name, final Object value) {
        Objects.requireNonNull(name);
        this._unknownMembers.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, Object> get() {
        if (this._unknownMembers.isEmpty()) {
            return null;
        }
        return this._unknownMembers;
    }

    @JsonIgnore
    public Iterable<String> getNames() {
        return this._unknownMembers.keySet();
    }

    public Object getValue(final String name) {
        if (name == null) {
            return null;
        }
        return this._unknownMembers.get(name);
    }

}
