/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.calculator;

import java.util.ArrayList;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.IBaseGeometry;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;
import net.anwiba.spatial.geometry.ILineSegment;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.LineSegment;
import net.anwiba.spatial.geometry.operator.LineSegmentIntersectOperator;
import net.anwiba.spatial.geometry.operator.LineStringInteractOperator;

public class InteriorCalculator {
    public static ICoordinate calculateInterior(final IGeometry geometry) {
        IGeometryTypeVisitor<ICoordinate, RuntimeException> visitor = new IGeometryTypeVisitor<ICoordinate, RuntimeException>(){

            @Override
            public ICoordinate visitUnknown() throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICoordinate visitPolygon() throws RuntimeException {
                IPolygon polygone = (IPolygon)geometry;
                return InteriorCalculator.calculateInterior(polygone);
            }

            @Override
            public ICoordinate visitPoint() throws RuntimeException {
                IPoint point = (IPoint)geometry;
                return InteriorCalculator.calculateInterior(point);
            }

            @Override
            public ICoordinate visitMultiPolygon() throws RuntimeException {
                IMultiPolygon multiPolygon = (IMultiPolygon)geometry;
                return InteriorCalculator.calculateInterior(multiPolygon);
            }

            @Override
            public ICoordinate visitMultiPoint() throws RuntimeException {
                IMultiPoint multiPoint = (IMultiPoint)geometry;
                return InteriorCalculator.calculateInterior(multiPoint);
            }

            @Override
            public ICoordinate visitMultiLineString() throws RuntimeException {
                IMultiLineString lineString = (IMultiLineString)geometry;
                return InteriorCalculator.calculateInterior(lineString);
            }

            @Override
            public ICoordinate visitLinearRing() throws RuntimeException {
                ILineString lineString = (ILineString)geometry;
                return InteriorCalculator.calculateInterior(lineString);
            }

            @Override
            public ICoordinate visitLineString() throws RuntimeException {
                ILineString lineString = (ILineString)geometry;
                return InteriorCalculator.calculateInterior(lineString);
            }

            @Override
            public ICoordinate visitCollection() throws RuntimeException {
                IGeometryCollection collection = (IGeometryCollection)geometry;
                return InteriorCalculator.calculateInterior(collection);
            }
        };
        return geometry.getGeometryType().accept(visitor);
    }

    public static ICoordinate calculateInterior(IMultiLineString geometry) {
        ICoordinateSequence sequence = new CoordinateSequenceFactory().createEmptyCoordinateSequence(2, false);
        Iterable<ILineString> geometries = geometry.geometries();
        for (ILineString lineString : geometries) {
            sequence = CoordinateSequenceUtilities.concat((ICoordinateSequence)sequence, (ICoordinateSequence)InteriorCalculator.getBisectorIntersections(lineString));
        }
        return CoordinateSequenceUtilities.findNearestNeighbor((ICoordinate)geometry.getEnvelope().getCenterCoordinate(), (ICoordinateSequence)sequence);
    }

    public static ICoordinate calculateInterior(ILineString geometry) {
        ICoordinateSequence sequence = InteriorCalculator.getBisectorIntersections(geometry);
        if (sequence.isEmpty()) {
            return null;
        }
        LineStringInteractOperator lineStringInteractOperator = new LineStringInteractOperator(geometry);
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        for (ICoordinate coordinate : sequence.getCoordinates()) {
            if (!lineStringInteractOperator.touch(coordinate)) continue;
            coordinates.add(coordinate);
        }
        if (coordinates.isEmpty()) {
            return null;
        }
        return CoordinateSequenceUtilities.findNearestNeighbor((ICoordinate)geometry.getEnvelope().getCenterCoordinate(), (ICoordinateSequence)new CoordinateSequenceFactory().create(coordinates));
    }

    public static ICoordinate calculateInterior(IPoint geometry) {
        return geometry.getCoordinateN(0);
    }

    public static ICoordinate calculateInterior(IMultiPoint geometry) {
        ICoordinateSequence coordinateSequence = geometry.getCoordinateSequence();
        return CoordinateSequenceUtilities.findNearestNeighbor((ICoordinate)geometry.getEnvelope().getCenterCoordinate(), (ICoordinateSequence)coordinateSequence);
    }

    public static ICoordinate calculateInterior(IPolygon geometry) {
        ICoordinateSequence sequence = InteriorCalculator.getBisectorIntersections(geometry);
        return CoordinateSequenceUtilities.findNearestNeighbor((ICoordinate)geometry.getEnvelope().getCenterCoordinate(), (ICoordinateSequence)sequence);
    }

    public static ICoordinate calculateInterior(IMultiPolygon geometry) {
        Iterable<IPolygon> geometries = geometry.geometries();
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        for (IPolygon polygon : geometries) {
            ICoordinate calculateInterior = InteriorCalculator.calculateInterior(polygon);
            if (calculateInterior == null) continue;
            coordinates.add(calculateInterior);
        }
        return CoordinateSequenceUtilities.findNearestNeighbor((ICoordinate)geometry.getEnvelope().getCenterCoordinate(), (ICoordinateSequence)new CoordinateSequenceFactory().create(coordinates));
    }

    public static ICoordinate calculateInterior(IGeometryCollection geometry) {
        Iterable<? extends IBaseGeometry> geometries = geometry.geometries();
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        for (IBaseGeometry iBaseGeometry : geometries) {
            coordinates.add(InteriorCalculator.calculateInterior(iBaseGeometry));
        }
        ICoordinateSequence iCoordinateSequence = geometry.getCoordinateSequence();
        ICoordinate centroid = CoordinateSequenceUtilities.calculateCentroid((ICoordinateSequence)iCoordinateSequence);
        return CoordinateSequenceUtilities.findNearestNeighbor((ICoordinate)centroid, (ICoordinateSequence)new CoordinateSequenceFactory().create(coordinates));
    }

    private static ICoordinateSequence getBisectorIntersections(IPolygon geometry) {
        IEnvelope envelope = geometry.getEnvelope();
        if (envelope.getHeight() == 0.0) {
            return new CoordinateSequenceFactory().create(new ICoordinate[]{envelope.getCenterCoordinate()});
        }
        ILineSegment bisector = InteriorCalculator.getBisector(envelope);
        ICoordinateSequence[] sequences = InteriorCalculator.getCoordinateSequence(geometry);
        return new LineSegmentIntersectOperator(bisector).calculate(sequences);
    }

    private static ICoordinateSequence[] getCoordinateSequence(IPolygon geometry) {
        ArrayList<ICoordinateSequence> sequences = new ArrayList<ICoordinateSequence>();
        Iterable<ILinearRing> innerRings = geometry.getInnerRings();
        sequences.add(geometry.getOuterRing().getCoordinateSequence());
        for (ILinearRing ring : innerRings) {
            sequences.add(ring.getCoordinateSequence());
        }
        return sequences.toArray(new ICoordinateSequence[sequences.size()]);
    }

    public static ICoordinateSequence getBisectorIntersections(IGeometry geometry) {
        IEnvelope envelope = geometry.getEnvelope();
        if (envelope.getHeight() == 0.0) {
            return new CoordinateSequenceFactory().create(new ICoordinate[]{envelope.getCenterCoordinate()});
        }
        ILineSegment bisector = InteriorCalculator.getBisector(envelope);
        return new LineSegmentIntersectOperator(bisector).calculate(geometry.getCoordinateSequence());
    }

    private static ILineSegment getBisector(IEnvelope envelope) {
        if (envelope.getWidth() > envelope.getHeight()) {
            ICoordinate cc = envelope.getCenterCoordinate();
            Coordinate c0 = new Coordinate(cc.getXValue(), cc.getYValue() + envelope.getHeight());
            Coordinate c1 = new Coordinate(cc.getXValue(), cc.getYValue() - envelope.getHeight());
            return new LineSegment((ICoordinate)c0, (ICoordinate)c1);
        }
        ICoordinate cc = envelope.getCenterCoordinate();
        Coordinate c0 = new Coordinate(cc.getXValue() - envelope.getWidth(), cc.getYValue());
        Coordinate c1 = new Coordinate(cc.getXValue() + envelope.getWidth(), cc.getYValue());
        return new LineSegment((ICoordinate)c0, (ICoordinate)c1);
    }
}

