/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.extract;

import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.extract.IGeometryExtractor;
import net.anwiba.spatial.geometry.extract.IGeometryReference;
import net.anwiba.spatial.geometry.extract.IPath;
import net.anwiba.spatial.geometry.extract.IStep;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;

public class GeometryExtractor
implements IGeometryExtractor {
    private final IGeometry geometry;

    public GeometryExtractor(IGeometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public IGeometry extract(IGeometryReference reference) {
        if (reference == null || this.geometry == null) {
            return this.geometry;
        }
        IPath path = reference.getPath();
        if (!path.hasStep()) {
            return this.geometry;
        }
        return this.extract(this.geometry, path.getStep());
    }

    private IGeometry extract(IGeometry geometry, IStep step) {
        if (step.hasNext()) {
            return this.extract(GeometryUtilities.extract(geometry, step.getIndex()), step.next());
        }
        return GeometryUtilities.extract(geometry, step.getIndex());
    }
}

