/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.ILineSegment;

public class LineSegment
implements ILineSegment {
    private final ICoordinate startPoint;
    private final ICoordinate endPoint;

    public LineSegment(ICoordinate startPoint, ICoordinate endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    @Override
    public ICoordinate getStartPoint() {
        return this.startPoint;
    }

    @Override
    public ICoordinate getEndPoint() {
        return this.endPoint;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean cordinateFlag = false;
        boolean ordinateFlag = false;
        ICoordinate[] iCoordinateArray = new ICoordinate[]{this.startPoint, this.endPoint};
        int n = iCoordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICoordinate coordinate = iCoordinateArray[n2];
            if (cordinateFlag) {
                buffer.append("; ");
            }
            cordinateFlag = true;
            double[] values = coordinate.getValues();
            ordinateFlag = false;
            double[] dArray = values;
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                double value = dArray[n4];
                if (ordinateFlag) {
                    buffer.append(", ");
                }
                ordinateFlag = true;
                buffer.append(value);
                ++n4;
            }
            ++n2;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public IEnvelope getEnvelope() {
        return new Envelope(new double[]{Math.min(this.startPoint.getXValue(), this.endPoint.getXValue()), Math.min(this.startPoint.getYValue(), this.endPoint.getYValue())}, new double[]{Math.max(this.startPoint.getXValue(), this.endPoint.getXValue()), Math.max(this.startPoint.getYValue(), this.endPoint.getYValue())}, false);
    }
}

