/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.operator.PointInteractOperator;

public class EnvelopeInteractOperator {
    private final IEnvelope envelope;

    public EnvelopeInteractOperator(IEnvelope envelope) {
        this.envelope = envelope == null ? Envelope.NULL_ENVELOPE : envelope;
    }

    public boolean covers(IGeometry geometry) {
        if (geometry == null) {
            return false;
        }
        return this.envelope.contains(geometry.getEnvelope());
    }

    public boolean interact(final IGeometry geometry) {
        if (geometry == null) {
            return false;
        }
        IGeometryTypeVisitor<Boolean, RuntimeException> visitor = new IGeometryTypeVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUnknown() throws RuntimeException {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitPolygon() throws RuntimeException {
                IPolygon polygon = (IPolygon)geometry;
                return EnvelopeInteractOperator.this.interact(polygon) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitPoint() throws RuntimeException {
                IPoint point = (IPoint)geometry;
                return EnvelopeInteractOperator.this.interact(point) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitMultiPolygon() throws RuntimeException {
                IMultiPolygon multiPolygon = (IMultiPolygon)geometry;
                return EnvelopeInteractOperator.this.interact(multiPolygon) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitMultiPoint() throws RuntimeException {
                IMultiPoint multiPoint = (IMultiPoint)geometry;
                return EnvelopeInteractOperator.this.interact(multiPoint) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitMultiLineString() throws RuntimeException {
                IMultiLineString multiLineString = (IMultiLineString)geometry;
                return EnvelopeInteractOperator.this.interact(multiLineString) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitLinearRing() throws RuntimeException {
                ILinearRing linearRing = (ILinearRing)geometry;
                return EnvelopeInteractOperator.this.interact(linearRing) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitLineString() throws RuntimeException {
                ILineString lineString = (ILineString)geometry;
                return EnvelopeInteractOperator.this.interact(lineString) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitCollection() throws RuntimeException {
                IGeometryCollection collection = (IGeometryCollection)geometry;
                return EnvelopeInteractOperator.this.interact(collection) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        return geometry.getGeometryType().accept(visitor);
    }

    private boolean interact(IPoint point) {
        return this.envelope.interact(point.getCoordinateN(0));
    }

    private boolean interact(IMultiPoint multiPoint) {
        IEnvelope geometryEnvelop = multiPoint.getEnvelope();
        if (!geometryEnvelop.interact(this.envelope)) {
            return false;
        }
        if (this.envelope.contains(geometryEnvelop)) {
            return true;
        }
        for (ICoordinate coordinate : multiPoint.getCoordinateSequence().getCoordinates()) {
            if (!this.envelope.interact(coordinate)) continue;
            return true;
        }
        return false;
    }

    private boolean interact(ILineString lineString) {
        IEnvelope geometryEnvelop = lineString.getEnvelope();
        if (!this.envelope.interact(geometryEnvelop)) {
            return false;
        }
        if (this.envelope.contains(geometryEnvelop)) {
            return true;
        }
        return this.isCrossing(lineString.getCoordinateSequence().getCoordinates());
    }

    private boolean interact(IGeometryCollection collection) {
        IEnvelope geometryEnvelop = collection.getEnvelope();
        if (!this.envelope.interact(geometryEnvelop)) {
            return false;
        }
        if (this.envelope.contains(geometryEnvelop)) {
            return true;
        }
        int i = 0;
        while (i < collection.getNumberOfGeometries()) {
            if (this.interact(collection.getGeometryN(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean interact(IMultiLineString multiLineString) {
        IEnvelope geometryEnvelop = multiLineString.getEnvelope();
        if (!this.envelope.interact(geometryEnvelop)) {
            return false;
        }
        if (this.envelope.contains(geometryEnvelop)) {
            return true;
        }
        int i = 0;
        while (i < multiLineString.getNumberOfGeometries()) {
            if (this.interact(multiLineString.getGeometryN(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean interact(IPolygon polygon) {
        IEnvelope geometryEnvelop = polygon.getEnvelope();
        if (!this.envelope.interact(geometryEnvelop)) {
            return false;
        }
        if (this.envelope.contains(geometryEnvelop)) {
            return true;
        }
        ICoordinateSequence coordinateSequence = this.envelope.getCoordinateSequence();
        int i = 0;
        while (i < 4) {
            if (new PointInteractOperator(coordinateSequence.getCoordinateN(i)).interact(polygon, 0.0)) {
                return true;
            }
            ++i;
        }
        return this.isCrossing(polygon.getOuterRing().getCoordinateSequence().getCoordinates());
    }

    private boolean interact(IMultiPolygon multiPolygon) {
        IEnvelope geometryEnvelop = multiPolygon.getEnvelope();
        if (!this.envelope.interact(geometryEnvelop)) {
            return false;
        }
        if (this.envelope.contains(geometryEnvelop)) {
            return true;
        }
        int i = 0;
        while (i < multiPolygon.getNumberOfGeometries()) {
            if (this.interact(multiPolygon.getGeometryN(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCrossing(Iterable<ICoordinate> coordinates) {
        ICoordinate previous = null;
        for (ICoordinate next : coordinates) {
            if (previous == null) {
                if (this.envelope.interact(next)) {
                    return true;
                }
                previous = next;
                continue;
            }
            if (this.envelope.interact(next)) {
                return true;
            }
            if (this.envelope.cross(previous, next)) {
                return true;
            }
            previous = next;
        }
        return false;
    }

    public boolean interact(ICoordinate coordinate) {
        return this.envelope.interact(coordinate);
    }

    public boolean interact(IEnvelope envelope) {
        if (envelope == null || Envelope.NULL_ENVELOPE.equals(envelope)) {
            return false;
        }
        return this.envelope.interact(envelope);
    }
}

