/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.EnvelopeUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.IPolygon;

public class PointInteractOperator {
    private final ICoordinate coordinate;

    public PointInteractOperator(IPoint point) {
        this(point.getCoordinateN(0));
    }

    public PointInteractOperator(ICoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public boolean interact(final IGeometry geometry, final double tolerance) {
        if (geometry == null) {
            return false;
        }
        IGeometryTypeVisitor<Boolean, RuntimeException> visitor = new IGeometryTypeVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUnknown() throws RuntimeException {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitPolygon() throws RuntimeException {
                IPolygon polygon = (IPolygon)geometry;
                return PointInteractOperator.this.interact(polygon, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitPoint() throws RuntimeException {
                IPoint point = (IPoint)geometry;
                return PointInteractOperator.this.interact(point, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitMultiPolygon() throws RuntimeException {
                IMultiPolygon polygones = (IMultiPolygon)geometry;
                return PointInteractOperator.this.interact(polygones, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitMultiPoint() throws RuntimeException {
                IMultiPoint points = (IMultiPoint)geometry;
                return PointInteractOperator.this.interact(points, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitMultiLineString() throws RuntimeException {
                IMultiLineString lineStrings = (IMultiLineString)geometry;
                return PointInteractOperator.this.interact(lineStrings, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitLinearRing() throws RuntimeException {
                ILinearRing linearRing = (ILinearRing)geometry;
                return PointInteractOperator.this.interact(linearRing, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitLineString() throws RuntimeException {
                ILineString lineString = (ILineString)geometry;
                return PointInteractOperator.this.interact(lineString, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Boolean visitCollection() throws RuntimeException {
                IGeometryCollection geometryCollection = (IGeometryCollection)geometry;
                return PointInteractOperator.this.interact(geometryCollection, tolerance) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        return geometry.getGeometryType().accept(visitor);
    }

    public boolean interact(IGeometryCollection collection, double tolerance) {
        for (IGeometry iGeometry : collection.geometries()) {
            if (!this.interact(iGeometry, tolerance)) continue;
            return true;
        }
        return false;
    }

    public boolean interact(IPoint point, double tolerance) {
        ICoordinate pointCoordinate = point.getCoordinateN(0);
        return CoordinateUtilities.interact((ICoordinate)pointCoordinate, (ICoordinate)this.coordinate, (double)tolerance);
    }

    public boolean interact(IMultiPoint multiPoint, double tolerance) {
        IEnvelope envelope = EnvelopeUtilities.createEnvelope((IEnvelope)multiPoint.getEnvelope(), (double)tolerance);
        if (!envelope.interact(this.coordinate)) {
            return false;
        }
        int i = 0;
        while (i < multiPoint.getNumberOfGeometries()) {
            if (this.interact(multiPoint.getGeometryN(i), tolerance)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean interact(ILineString line, double tolerance) {
        IEnvelope envelope = EnvelopeUtilities.createEnvelope((IEnvelope)line.getEnvelope(), (double)tolerance);
        if (!envelope.interact(this.coordinate)) {
            return false;
        }
        ICoordinateSequence coordinateSequence = line.getCoordinateSequence();
        ICoordinate previous = null;
        for (ICoordinate next : coordinateSequence.getCoordinates()) {
            if (previous == null) {
                if (CoordinateUtilities.interact((ICoordinate)this.coordinate, (ICoordinate)next, (double)tolerance)) {
                    return true;
                }
                previous = next;
                continue;
            }
            if (CoordinateUtilities.isBetween(previous, (ICoordinate)next, (ICoordinate)this.coordinate, (double)tolerance)) {
                return true;
            }
            previous = next;
        }
        return false;
    }

    public boolean interact(IMultiLineString multiLineString, double tolerance) {
        IEnvelope envelope = EnvelopeUtilities.createEnvelope((IEnvelope)multiLineString.getEnvelope(), (double)tolerance);
        if (!envelope.interact(this.coordinate)) {
            return false;
        }
        int i = 0;
        while (i < multiLineString.getNumberOfGeometries()) {
            if (this.interact(multiLineString.getGeometryN(i), tolerance)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean interact(IPolygon polygon, double tolerance) {
        IEnvelope envelope = EnvelopeUtilities.createEnvelope((IEnvelope)polygon.getEnvelope(), (double)tolerance);
        if (!envelope.interact(this.coordinate)) {
            return false;
        }
        if (CoordinateUtilities.isPointInRing((ICoordinate)this.coordinate, (ICoordinateSequence)polygon.getOuterRing().getCoordinateSequence())) {
            int i = 0;
            while (i < polygon.getNumberOfInnerRings()) {
                ILinearRing innerRing = polygon.getInnerRingN(i);
                if (innerRing.getEnvelope().interact(this.coordinate) && CoordinateUtilities.isPointInRing((ICoordinate)this.coordinate, (ICoordinateSequence)innerRing.getCoordinateSequence())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.interact(polygon.getOuterRing(), tolerance);
    }

    public boolean interact(IMultiPolygon polygon, double tolerance) {
        IEnvelope envelope = EnvelopeUtilities.createEnvelope((IEnvelope)polygon.getEnvelope(), (double)tolerance);
        if (!envelope.interact(this.coordinate)) {
            return false;
        }
        int i = 0;
        while (i < polygon.getNumberOfGeometries()) {
            if (this.interact(polygon.getGeometryN(i), tolerance)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

