/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import java.util.List;
import net.anwiba.spatial.geometry.IGeometryFactoryProvider;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.polygon.AbstractPolygonBuilder;

public class MultiPolygonBuilder
extends AbstractPolygonBuilder {
    private final IGeometryFactoryProvider factoryProvider;

    public MultiPolygonBuilder(IGeometryFactoryProvider factoryProvider) {
        super(factoryProvider);
        this.factoryProvider = factoryProvider;
    }

    @Override
    public IMultiPolygon build() {
        List<IPolygon> polygons = this.getPolygons();
        if (polygons.isEmpty()) {
            return this.factoryProvider.getGeometryFactory(null).createMultiPolygon(polygons.toArray(new IPolygon[polygons.size()]));
        }
        return this.factoryProvider.getGeometryFactory(polygons.get(0).getCoordinateReferenceSystem()).createMultiPolygon(polygons.toArray(new IPolygon[polygons.size()]));
    }
}

